/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store.windowpool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.neo4j.consistency.store.paging.Cart;
import org.neo4j.consistency.store.windowpool.FileMapper;
import org.neo4j.consistency.store.windowpool.LoggingStatisticsListener;
import org.neo4j.consistency.store.windowpool.MappingStatisticsListener;
import org.neo4j.consistency.store.windowpool.ScanResistantWindowPool;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class ScanResistantWindowPoolFactory
implements WindowPoolFactory {
    private final int targetBytesPerPage;
    private final Cart cart;
    private final int reportingInterval;
    private final MappingStatisticsListener statisticsListener;

    public ScanResistantWindowPoolFactory(Config configuration, StringLogger logger) {
        this.targetBytesPerPage = ScanResistantWindowPoolFactory.pageSize(configuration);
        this.cart = new Cart(ScanResistantWindowPoolFactory.mappablePages(configuration, this.targetBytesPerPage));
        this.reportingInterval = (Integer)configuration.get((Setting)GraphDatabaseSettings.log_mapped_memory_stats_interval);
        this.statisticsListener = this.createStatisticsListener(configuration, logger);
    }

    private static int pageSize(Config configuration) {
        long pageSize = (Long)configuration.get((Setting)GraphDatabaseSettings.mapped_memory_page_size);
        if (pageSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("configured page size [%d bytes] is too large", pageSize));
        }
        return (int)pageSize;
    }

    private static int mappablePages(Config configuration, int targetBytesPerPage) {
        long bytes = (Long)configuration.get((Setting)GraphDatabaseSettings.all_stores_total_mapped_memory_size);
        long pageCount = bytes / (long)targetBytesPerPage;
        if (pageCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("configured page size [%d bytes] and mapped memory [%d bytes] implies too many pages", targetBytesPerPage, bytes));
        }
        return (int)pageCount;
    }

    private MappingStatisticsListener createStatisticsListener(Config configuration, StringLogger logger) {
        if (((Boolean)configuration.get((Setting)GraphDatabaseSettings.log_mapped_memory_stats)).booleanValue()) {
            try {
                return new LoggingStatisticsListener((File)configuration.get((Setting)GraphDatabaseSettings.log_mapped_memory_stats_filename));
            }
            catch (FileNotFoundException e) {
                logger.logMessage("Unable to create logger for mapped memory statistics; will be silent", (Throwable)e);
            }
        }
        return new MappingStatisticsListener(){

            @Override
            public void onStatistics(File storeFileName, int acquiredPages, int mappedPages, long samplePeriod) {
            }
        };
    }

    public WindowPool create(File storageFileName, int recordSize, StoreChannel fileChannel, Config configuration, StringLogger log) {
        try {
            return new ScanResistantWindowPool(storageFileName, recordSize, this.targetBytesPerPage, new FileMapper(fileChannel), this.cart, this.reportingInterval, this.statisticsListener);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }
}

