/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.AbstractStoreProcessor;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;

class StoreProcessor
extends AbstractStoreProcessor {
    private final ConsistencyReport.Reporter report;

    public StoreProcessor(CheckDecorator decorator, ConsistencyReport.Reporter report) {
        super(decorator);
        this.report = report;
    }

    @Override
    protected void checkNode(RecordStore<NodeRecord> store, NodeRecord node, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.report.forNode(node, checker);
    }

    @Override
    protected void checkRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        this.report.forRelationship(rel, checker);
    }

    @Override
    protected void checkProperty(RecordStore<PropertyRecord> store, PropertyRecord property, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.report.forProperty(property, checker);
    }

    @Override
    protected void checkRelationshipLabel(RecordStore<RelationshipTypeRecord> store, RelationshipTypeRecord label, RecordCheck<RelationshipTypeRecord, ConsistencyReport.LabelConsistencyReport> checker) {
        this.report.forRelationshipLabel(label, checker);
    }

    @Override
    protected void checkPropertyIndex(RecordStore<PropertyIndexRecord> store, PropertyIndexRecord key, RecordCheck<PropertyIndexRecord, ConsistencyReport.PropertyKeyConsistencyReport> checker) {
        this.report.forPropertyKey(key, checker);
    }

    @Override
    protected void checkDynamic(RecordType type, RecordStore<DynamicRecord> store, DynamicRecord string, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.report.forDynamicBlock(type, string, checker);
    }
}

