/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;

public class ConsistencyReporter
implements ConsistencyReport.Reporter {
    private static final Method FOR_REFERENCE;
    private static final ProxyFactory<ConsistencyReport.NodeConsistencyReport> NODE_REPORT;
    private static final ProxyFactory<ConsistencyReport.RelationshipConsistencyReport> RELATIONSHIP_REPORT;
    private static final ProxyFactory<ConsistencyReport.PropertyConsistencyReport> PROPERTY_REPORT;
    private static final ProxyFactory<ConsistencyReport.LabelConsistencyReport> LABEL_REPORT;
    private static final ProxyFactory<ConsistencyReport.PropertyKeyConsistencyReport> PROPERTY_KEY_REPORT;
    private static final ProxyFactory<ConsistencyReport.DynamicConsistencyReport> DYNAMIC_REPORT;
    private final DiffRecordAccess records;
    private final InconsistencyReport report;

    public ConsistencyReporter(DiffRecordAccess records, InconsistencyReport report) {
        this.records = records;
        this.report = report;
    }

    private <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport<RECORD, REPORT>> void dispatch(RecordType type, ProxyFactory<REPORT> factory, RECORD record, RecordCheck<RECORD, REPORT> checker) {
        ReportHandler handler = new ReportHandler(this.report, type, record);
        checker.check(record, (ConsistencyReport)factory.create(handler), this.records);
        handler.updateSummary();
    }

    private <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport<RECORD, REPORT>> void dispatchChange(RecordType type, ProxyFactory<REPORT> factory, RECORD oldRecord, RECORD newRecord, RecordCheck<RECORD, REPORT> checker) {
        DiffReportHandler handler = new DiffReportHandler(this.report, type, oldRecord, newRecord);
        checker.checkChange(oldRecord, newRecord, (ConsistencyReport)factory.create(handler), this.records);
        handler.updateSummary();
    }

    static void dispatchReference(ConsistencyReport report, ComparativeRecordChecker checker, AbstractBaseRecord referenced, RecordAccess records) {
        ReportInvocationHandler handler = (ReportInvocationHandler)Proxy.getInvocationHandler(report);
        handler.checkReference(report, checker, referenced, records);
        handler.updateSummary();
    }

    static String pendingCheckToString(ConsistencyReport report, ComparativeRecordChecker checker) {
        ReportInvocationHandler handler = (ReportInvocationHandler)Proxy.getInvocationHandler(report);
        return handler.pendingCheckToString(checker);
    }

    static void dispatchChangeReference(ConsistencyReport report, ComparativeRecordChecker checker, AbstractBaseRecord oldReferenced, AbstractBaseRecord newReferenced, RecordAccess records) {
        ReportInvocationHandler handler = (ReportInvocationHandler)Proxy.getInvocationHandler(report);
        handler.checkDiffReference(report, checker, oldReferenced, newReferenced, records);
        handler.updateSummary();
    }

    static void dispatchSkip(ConsistencyReport report) {
        ((ReportInvocationHandler)Proxy.getInvocationHandler(report)).updateSummary();
    }

    @Override
    public void forNode(NodeRecord node, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.dispatch(RecordType.NODE, NODE_REPORT, node, checker);
    }

    @Override
    public void forNodeChange(NodeRecord oldNode, NodeRecord newNode, RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        this.dispatchChange(RecordType.NODE, NODE_REPORT, oldNode, newNode, checker);
    }

    @Override
    public void forRelationship(RelationshipRecord relationship, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        this.dispatch(RecordType.RELATIONSHIP, RELATIONSHIP_REPORT, relationship, checker);
    }

    @Override
    public void forRelationshipChange(RelationshipRecord oldRelationship, RelationshipRecord newRelationship, RecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        this.dispatchChange(RecordType.RELATIONSHIP, RELATIONSHIP_REPORT, oldRelationship, newRelationship, checker);
    }

    @Override
    public void forProperty(PropertyRecord property, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.dispatch(RecordType.PROPERTY, PROPERTY_REPORT, property, checker);
    }

    @Override
    public void forPropertyChange(PropertyRecord oldProperty, PropertyRecord newProperty, RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        this.dispatchChange(RecordType.PROPERTY, PROPERTY_REPORT, oldProperty, newProperty, checker);
    }

    @Override
    public void forRelationshipLabel(RelationshipTypeRecord label, RecordCheck<RelationshipTypeRecord, ConsistencyReport.LabelConsistencyReport> checker) {
        this.dispatch(RecordType.RELATIONSHIP_LABEL, LABEL_REPORT, label, checker);
    }

    @Override
    public void forRelationshipLabelChange(RelationshipTypeRecord oldLabel, RelationshipTypeRecord newLabel, RecordCheck<RelationshipTypeRecord, ConsistencyReport.LabelConsistencyReport> checker) {
        this.dispatchChange(RecordType.RELATIONSHIP_LABEL, LABEL_REPORT, oldLabel, newLabel, checker);
    }

    @Override
    public void forPropertyKey(PropertyIndexRecord key, RecordCheck<PropertyIndexRecord, ConsistencyReport.PropertyKeyConsistencyReport> checker) {
        this.dispatch(RecordType.PROPERTY_KEY, PROPERTY_KEY_REPORT, key, checker);
    }

    @Override
    public void forPropertyKeyChange(PropertyIndexRecord oldKey, PropertyIndexRecord newKey, RecordCheck<PropertyIndexRecord, ConsistencyReport.PropertyKeyConsistencyReport> checker) {
        this.dispatchChange(RecordType.PROPERTY_KEY, PROPERTY_KEY_REPORT, oldKey, newKey, checker);
    }

    @Override
    public void forDynamicBlock(RecordType type, DynamicRecord record, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.dispatch(type, DYNAMIC_REPORT, record, checker);
    }

    @Override
    public void forDynamicBlockChange(RecordType type, DynamicRecord oldRecord, DynamicRecord newRecord, RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        this.dispatchChange(type, DYNAMIC_REPORT, oldRecord, newRecord, checker);
    }

    static {
        try {
            FOR_REFERENCE = ConsistencyReport.class.getDeclaredMethod("forReference", RecordReference.class, ComparativeRecordChecker.class);
        }
        catch (NoSuchMethodException cause) {
            throw (LinkageError)Exceptions.withCause((Throwable)new LinkageError("Could not find dispatch method of " + ConsistencyReport.class.getName()), (Throwable)cause);
        }
        NODE_REPORT = ProxyFactory.create(ConsistencyReport.NodeConsistencyReport.class);
        RELATIONSHIP_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipConsistencyReport.class);
        PROPERTY_REPORT = ProxyFactory.create(ConsistencyReport.PropertyConsistencyReport.class);
        LABEL_REPORT = ProxyFactory.create(ConsistencyReport.LabelConsistencyReport.class);
        PROPERTY_KEY_REPORT = ProxyFactory.create(ConsistencyReport.PropertyKeyConsistencyReport.class);
        DYNAMIC_REPORT = ProxyFactory.create(ConsistencyReport.DynamicConsistencyReport.class);
    }

    private static class ProxyFactory<T> {
        private Constructor<? extends T> constructor;

        ProxyFactory(Class<T> type) throws LinkageError {
            try {
                this.constructor = Proxy.getProxyClass(ConsistencyReporter.class.getClassLoader(), type).getConstructor(InvocationHandler.class);
            }
            catch (NoSuchMethodException e) {
                throw (LinkageError)Exceptions.withCause((Throwable)new LinkageError("Cannot access Proxy constructor for " + type.getName()), (Throwable)e);
            }
        }

        public T create(InvocationHandler handler) {
            try {
                return this.constructor.newInstance(handler);
            }
            catch (InvocationTargetException e) {
                throw Exceptions.launderedException((Throwable)e);
            }
            catch (Exception e) {
                throw new LinkageError("Failed to create proxy instance");
            }
        }

        public static <T> ProxyFactory<T> create(Class<T> type) {
            return new ProxyFactory<T>(type);
        }
    }

    private static class DiffReportHandler
    extends ReportInvocationHandler {
        private final AbstractBaseRecord oldRecord;
        private final AbstractBaseRecord newRecord;

        private DiffReportHandler(InconsistencyReport report, RecordType type, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord) {
            super(report, type);
            this.oldRecord = oldRecord;
            this.newRecord = newRecord;
        }

        @Override
        long recordId() {
            return this.newRecord.getLongId();
        }

        @Override
        protected void logError(String message, Object[] args) {
            this.report.error(this.type, this.oldRecord, this.newRecord, message, args);
        }

        @Override
        protected void logWarning(String message, Object[] args) {
            this.report.warning(this.type, this.oldRecord, this.newRecord, message, args);
        }

        @Override
        void checkReference(ConsistencyReport report, ComparativeRecordChecker checker, AbstractBaseRecord referenced, RecordAccess records) {
            checker.checkReference(this.newRecord, referenced, report, records);
        }

        @Override
        void checkDiffReference(ConsistencyReport report, ComparativeRecordChecker checker, AbstractBaseRecord oldReferenced, AbstractBaseRecord newReferenced, RecordAccess records) {
            checker.checkReference(this.newRecord, newReferenced, report, records);
        }
    }

    static class ReportHandler
    extends ReportInvocationHandler {
        private final AbstractBaseRecord record;

        ReportHandler(InconsistencyReport report, RecordType type, AbstractBaseRecord record) {
            super(report, type);
            this.record = record;
        }

        @Override
        long recordId() {
            return this.record.getLongId();
        }

        @Override
        protected void logError(String message, Object[] args) {
            this.report.error(this.type, this.record, message, args);
        }

        @Override
        protected void logWarning(String message, Object[] args) {
            this.report.warning(this.type, this.record, message, args);
        }

        @Override
        void checkReference(ConsistencyReport report, ComparativeRecordChecker checker, AbstractBaseRecord referenced, RecordAccess records) {
            checker.checkReference(this.record, referenced, report, records);
        }

        @Override
        void checkDiffReference(ConsistencyReport report, ComparativeRecordChecker checker, AbstractBaseRecord oldReferenced, AbstractBaseRecord newReferenced, RecordAccess records) {
            checker.checkReference(this.record, newReferenced, report, records);
        }
    }

    private static abstract class ReportInvocationHandler
    implements InvocationHandler {
        final InconsistencyReport report;
        final RecordType type;
        private short errors = 0;
        private short warnings = 0;
        private short references = 1;

        private ReportInvocationHandler(InconsistencyReport report, RecordType type) {
            this.report = report;
            this.type = type;
        }

        synchronized void updateSummary() {
            this.references = (short)(this.references - 1);
            if (this.references == 0) {
                this.report.updateSummary(this.type, this.errors, this.warnings);
            }
        }

        String pendingCheckToString(ComparativeRecordChecker checker) {
            String checkName;
            try {
                if (checker.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                    checkName = checker.getClass().getSimpleName();
                    if (checkName.length() == 0) {
                        checkName = checker.getClass().getName();
                    }
                } else {
                    checkName = checker.toString();
                }
            }
            catch (NoSuchMethodException e) {
                checkName = checker.toString();
            }
            return String.format("ReferenceCheck{%s[%s]/%s}", new Object[]{this.type, this.recordId(), checkName});
        }

        abstract long recordId();

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(FOR_REFERENCE)) {
                RecordReference reference = (RecordReference)args[0];
                ComparativeRecordChecker checker = (ComparativeRecordChecker)args[1];
                this.dispatchForReference((ConsistencyReport)proxy, reference, checker);
            } else {
                Documented annotation = method.getAnnotation(Documented.class);
                String message = annotation != null && !"".equals(annotation.value()) ? annotation.value() : method.getName();
                if (method.getAnnotation(ConsistencyReport.Warning.class) == null) {
                    this.errors = (short)(this.errors + 1);
                    this.logError(message, args);
                } else {
                    this.warnings = (short)(this.warnings + 1);
                    this.logWarning(message, args);
                }
            }
            return null;
        }

        protected abstract void logError(String var1, Object[] var2);

        protected abstract void logWarning(String var1, Object[] var2);

        private void dispatchForReference(ConsistencyReport report, RecordReference reference, ComparativeRecordChecker checker) {
            this.forReference(report, reference, checker);
        }

        final <REFERENCED extends AbstractBaseRecord> void forReference(ConsistencyReport report, RecordReference<REFERENCED> reference, ComparativeRecordChecker<?, REFERENCED, ?> checker) {
            this.references = (short)(this.references + 1);
            reference.dispatch(new PendingReferenceCheck(report, checker));
        }

        abstract void checkReference(ConsistencyReport var1, ComparativeRecordChecker var2, AbstractBaseRecord var3, RecordAccess var4);

        abstract void checkDiffReference(ConsistencyReport var1, ComparativeRecordChecker var2, AbstractBaseRecord var3, AbstractBaseRecord var4, RecordAccess var5);
    }
}

