/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store.windowpool;

import java.io.IOException;
import org.neo4j.consistency.store.paging.PageLoadFailureException;
import org.neo4j.consistency.store.paging.PageReplacementStrategy;
import org.neo4j.consistency.store.windowpool.FileMapper;
import org.neo4j.consistency.store.windowpool.MappingStatisticsListener;
import org.neo4j.consistency.store.windowpool.WindowPage;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;

public class ScanResistantWindowPool
implements WindowPool,
PageReplacementStrategy.Storage<PersistenceWindow, WindowPage> {
    private final String storeFileName;
    private final FileMapper fileMapper;
    private final PageReplacementStrategy replacementStrategy;
    private final int bytesPerRecord;
    private final int recordsPerPage;
    private final int reportInterval;
    private final MappingStatisticsListener statisticsListener;
    private WindowPage[] pages = new WindowPage[0];
    private int acquireCount = 0;
    private int mapCount = 0;
    private int lastMapCount;
    private long lastReportTime = System.currentTimeMillis();

    public ScanResistantWindowPool(String storeFileName, int bytesPerRecord, int targetBytesPerPage, FileMapper fileMapper, PageReplacementStrategy replacementStrategy, int reportInterval, MappingStatisticsListener statisticsListener) throws IOException {
        this.storeFileName = storeFileName;
        this.bytesPerRecord = bytesPerRecord;
        this.fileMapper = fileMapper;
        this.replacementStrategy = replacementStrategy;
        this.statisticsListener = statisticsListener;
        this.recordsPerPage = ScanResistantWindowPool.calculateNumberOfRecordsPerPage(bytesPerRecord, targetBytesPerPage);
        this.reportInterval = reportInterval;
        this.setupPages();
    }

    private static int calculateNumberOfRecordsPerPage(int bytesPerRecord, int targetBytesPerPage) {
        if (bytesPerRecord <= 0 || bytesPerRecord > targetBytesPerPage) {
            throw new IllegalArgumentException(String.format("number of bytes per record [%d] is not in the valid range [1-%d]", bytesPerRecord, targetBytesPerPage));
        }
        return targetBytesPerPage / bytesPerRecord;
    }

    private void setupPages() throws IOException {
        this.page(this.fileMapper.fileSizeInBytes() / (long)this.bytesPerRecord);
    }

    private int pageNumber(long position) {
        long pageNumber = position / (long)this.recordsPerPage;
        if (pageNumber + 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Position [record %d] with current page size [%d records/page] implies an impossible page number [%d].", position, this.recordsPerPage, pageNumber));
        }
        return (int)(position / (long)this.recordsPerPage);
    }

    private WindowPage page(long position) {
        int pageNumber = this.pageNumber(position);
        if (pageNumber >= this.pages.length) {
            WindowPage[] newPages = new WindowPage[pageNumber + 1];
            System.arraycopy(this.pages, 0, newPages, 0, this.pages.length);
            for (int i = this.pages.length; i < newPages.length; ++i) {
                newPages[i] = new WindowPage((long)i * (long)this.recordsPerPage);
            }
            this.pages = newPages;
        }
        return this.pages[pageNumber];
    }

    public PersistenceWindow acquire(long position, OperationType operationType) {
        if (operationType != OperationType.READ) {
            throw new UnsupportedOperationException("Only supports READ operations.");
        }
        try {
            ++this.acquireCount;
            PersistenceWindow persistenceWindow = this.replacementStrategy.acquire(this.page(position), this);
            return persistenceWindow;
        }
        catch (PageLoadFailureException e) {
            throw new UnderlyingStorageException("Unable to load position[" + position + "] @[" + position * (long)this.bytesPerRecord + "]", (Throwable)e);
        }
        finally {
            this.reportStats();
        }
    }

    private void reportStats() {
        if (this.acquireCount % this.reportInterval == 0) {
            int deltaMapCount = this.mapCount - this.lastMapCount;
            this.lastMapCount = this.mapCount;
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - this.lastReportTime;
            this.lastReportTime = currentTime;
            this.statisticsListener.onStatistics(WindowPoolStats.extractName((String)this.storeFileName), this.reportInterval, deltaMapCount, deltaTime);
        }
    }

    public void release(PersistenceWindow window) {
    }

    public void flushAll() {
    }

    public void close() {
        for (WindowPage page : this.pages) {
            this.replacementStrategy.forceEvict(page);
        }
    }

    public WindowPoolStats getStats() {
        return new WindowPoolStats(this.storeFileName, 0L, 0L, this.pages.length, this.bytesPerRecord * this.recordsPerPage, this.acquireCount - this.mapCount, this.mapCount, 0, 0, 0, 0, 0);
    }

    @Override
    public PersistenceWindow load(WindowPage page) throws PageLoadFailureException {
        try {
            ++this.mapCount;
            return this.fileMapper.mapWindow(page.firstRecord, this.recordsPerPage, this.bytesPerRecord);
        }
        catch (IOException e) {
            throw new PageLoadFailureException(e);
        }
    }
}

