/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.incremental.intercept;

import java.util.HashMap;
import org.neo4j.consistency.checking.incremental.DiffCheck;
import org.neo4j.consistency.checking.incremental.intercept.CheckingTransactionInterceptor;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;

abstract class CheckingTransactionInterceptorProvider
extends TransactionInterceptorProvider {
    public CheckingTransactionInterceptorProvider(String name) {
        super(name);
    }

    abstract DiffCheck createChecker(String var1, StringLogger var2);

    public CheckingTransactionInterceptor create(XaDataSource ds, Object options, DependencyResolver dependencyResolver) {
        if (!(ds instanceof NeoStoreXaDataSource) || !(options instanceof String)) {
            return null;
        }
        String[] config = ((String)options).split(";");
        String mode = config[0];
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 1; i < config.length; ++i) {
            String[] parts = config[i].split("=");
            parameters.put(parts[0].toLowerCase(), parts.length == 1 ? "true" : parts[1]);
        }
        StringLogger logger = (StringLogger)dependencyResolver.resolveDependency(StringLogger.class);
        DiffCheck check = this.createChecker(mode, logger);
        if (check == null) {
            return null;
        }
        String log = (String)parameters.get("log");
        return new CheckingTransactionInterceptor(check, (NeoStoreXaDataSource)ds, logger, log);
    }

    public CheckingTransactionInterceptor create(TransactionInterceptor next, XaDataSource ds, Object options, DependencyResolver dependencyResolver) {
        CheckingTransactionInterceptor interceptor = this.create(ds, options, dependencyResolver);
        if (interceptor != null) {
            interceptor.setNext(next);
        }
        return interceptor;
    }
}

