/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

public class DiffRecordStore<R extends AbstractBaseRecord>
implements RecordStore<R>,
Iterable<Long> {
    private final RecordStore<R> actual;
    private final Map<Long, R> diff;
    private long highId = -1L;

    public DiffRecordStore(RecordStore<R> actual) {
        this.actual = actual;
        this.diff = new HashMap<Long, R>();
    }

    public String toString() {
        return "Diff/" + this.actual;
    }

    public void markDirty(long id) {
        if (!this.diff.containsKey(id)) {
            this.diff.put(id, null);
        }
    }

    public boolean isModified(long id) {
        return this.diff.get(id) != null;
    }

    public R forceGetRaw(R record) {
        if (this.diff.containsKey(record.getLongId())) {
            return (R)this.actual.forceGetRecord(record.getLongId());
        }
        return record;
    }

    public R forceGetRaw(long id) {
        return (R)this.actual.forceGetRecord(id);
    }

    public int getRecordHeaderSize() {
        return this.actual.getRecordHeaderSize();
    }

    public int getRecordSize() {
        return this.actual.getRecordSize();
    }

    public String getStorageFileName() {
        return this.actual.getStorageFileName();
    }

    public WindowPoolStats getWindowPoolStats() {
        return this.actual.getWindowPoolStats();
    }

    public long getHighId() {
        return Math.max(this.highId, this.actual.getHighId());
    }

    public long getRawHighId() {
        return this.actual.getHighId();
    }

    public R getRecord(long id) {
        return this.getRecord(id, false);
    }

    public R forceGetRecord(long id) {
        return this.getRecord(id, true);
    }

    private R getRecord(long id, boolean force) {
        AbstractBaseRecord record = (AbstractBaseRecord)this.diff.get(id);
        if (record == null) {
            return (R)(force ? this.actual.forceGetRecord(id) : this.actual.getRecord(id));
        }
        if (!force && !record.inUse()) {
            throw new InvalidRecordException(record.getClass().getSimpleName() + "[" + id + "] not in use");
        }
        return (R)record;
    }

    public void updateRecord(R record) {
        if (record.getLongId() > this.highId) {
            this.highId = record.getLongId();
        }
        this.diff.put(record.getLongId(), record);
    }

    public void forceUpdateRecord(R record) {
        this.updateRecord(record);
    }

    public void accept(RecordStore.Processor processor, R record) {
        this.actual.accept((RecordStore.Processor)new DispatchProcessor(this, processor), record);
    }

    @Override
    public Iterator<Long> iterator() {
        return this.diff.keySet().iterator();
    }

    public void close() {
        this.diff.clear();
        this.actual.close();
    }

    public R getChangedRecord(long id) {
        return (R)((AbstractBaseRecord)this.diff.get(id));
    }

    private static class DispatchProcessor
    extends RecordStore.Processor {
        private final DiffRecordStore<?> diffStore;
        private final RecordStore.Processor processor;

        DispatchProcessor(DiffRecordStore<?> diffStore, RecordStore.Processor processor) {
            this.diffStore = diffStore;
            this.processor = processor;
        }

        public void processNode(RecordStore<NodeRecord> store, NodeRecord node) {
            this.processor.processNode(this.diffStore, node);
        }

        public void processRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel) {
            this.processor.processRelationship(this.diffStore, rel);
        }

        public void processProperty(RecordStore<PropertyRecord> store, PropertyRecord property) {
            this.processor.processProperty(this.diffStore, property);
        }

        public void processString(RecordStore<DynamicRecord> store, DynamicRecord string, IdType idType) {
            this.processor.processString(this.diffStore, string, idType);
        }

        public void processArray(RecordStore<DynamicRecord> store, DynamicRecord array) {
            this.processor.processArray(this.diffStore, array);
        }

        public void processRelationshipType(RecordStore<RelationshipTypeRecord> store, RelationshipTypeRecord record) {
            this.processor.processRelationshipType(this.diffStore, record);
        }

        public void processPropertyIndex(RecordStore<PropertyIndexRecord> store, PropertyIndexRecord record) {
            this.processor.processPropertyIndex(this.diffStore, record);
        }
    }
}

