/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.TaskExecutionOrder;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;

class StoreProcessorTask<R extends AbstractBaseRecord>
implements Runnable {
    private final RecordStore<R> store;
    private final StoreProcessor[] processors;
    private final ProgressListener[] progressListeners;

    StoreProcessorTask(RecordStore<R> store, ProgressMonitorFactory.MultiPartBuilder builder, TaskExecutionOrder order, StoreProcessor singlePassProcessor, StoreProcessor ... multiPassProcessors) {
        this.store = store;
        String storeFileName = store.getStorageFileName().substring(store.getStorageFileName().lastIndexOf(47) + 1);
        if (order == TaskExecutionOrder.MULTI_PASS) {
            this.processors = multiPassProcessors;
            this.progressListeners = new ProgressListener[multiPassProcessors.length];
            for (int i = 0; i < multiPassProcessors.length; ++i) {
                this.progressListeners[i] = builder.progressForPart(storeFileName + "_pass_" + i, store.getHighId());
            }
        } else {
            this.processors = new StoreProcessor[]{singlePassProcessor};
            this.progressListeners = new ProgressListener[]{builder.progressForPart(storeFileName, store.getHighId())};
        }
    }

    @Override
    public void run() {
        for (int i = 0; i < this.processors.length; ++i) {
            try {
                this.processors[i].applyFiltered(this.store, this.progressListeners[i], new Predicate[0]);
                continue;
            }
            catch (Throwable e) {
                this.progressListeners[i].failed(e);
            }
        }
    }

    public void stopScanning() {
        this.processors[0].stopScanning();
    }
}

