/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.util.concurrent.AsyncApply;
import org.neo4j.util.concurrent.Work;

public class WorkSync<Material, W extends Work<Material, W>> {
    private final Material material;
    private final AtomicReference<WorkUnit<Material, W>> stack;
    private static final WorkUnit<?, ?> stackEnd = new WorkUnit(null, null, null);
    private final AtomicReference<Thread> lock;

    public WorkSync(Material material) {
        this.material = material;
        this.stack = new AtomicReference(stackEnd);
        this.lock = new AtomicReference();
    }

    public void apply(W work) throws ExecutionException {
        WorkUnit<Material, W> unit = this.enqueueWork(work);
        int tryCount = 0;
        do {
            this.checkFailure(this.tryDoWork(unit, ++tryCount, true));
        } while (!unit.isDone());
    }

    public AsyncApply applyAsync(W work) {
        final WorkUnit<Material, W> unit = this.enqueueWork(work);
        final Throwable initialThrowable = this.tryDoWork(unit, 100, false);
        return new AsyncApply(){
            Throwable throwable;
            {
                this.throwable = initialThrowable;
            }

            @Override
            public void await() throws ExecutionException {
                WorkSync.this.checkFailure(this.throwable);
                int tryCount = 0;
                while (!unit.isDone()) {
                    this.throwable = WorkSync.this.tryDoWork(unit, ++tryCount, true);
                    WorkSync.this.checkFailure(this.throwable);
                }
            }
        };
    }

    private WorkUnit<Material, W> enqueueWork(W work) {
        WorkUnit unit = new WorkUnit((Work)work, Thread.currentThread(), null);
        unit.next = this.stack.getAndSet(unit);
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable tryDoWork(WorkUnit<Material, W> unit, int tryCount, boolean block) {
        if (this.tryLock(tryCount, unit, block)) {
            WorkUnit<Material, W> batch = this.grabBatch();
            try {
                Throwable throwable = this.doSynchronizedWork(batch);
                return throwable;
            }
            finally {
                this.unlock();
                this.unparkAnyWaiters();
                this.markAsDone(batch);
            }
        }
        return null;
    }

    private void unparkAnyWaiters() {
        WorkUnit<Material, W> waiter = this.stack.get();
        if (waiter != stackEnd) {
            waiter.unpark();
        }
    }

    private void checkFailure(Throwable failure) throws ExecutionException {
        if (failure != null) {
            throw new ExecutionException(failure);
        }
    }

    private boolean tryLock(int tryCount, WorkUnit<Material, W> unit, boolean block) {
        if (this.lock.compareAndSet(null, Thread.currentThread())) {
            return true;
        }
        if (tryCount < 10) {
            Thread.yield();
        } else if (block) {
            unit.park(10L, TimeUnit.MILLISECONDS);
        }
        return false;
    }

    private void unlock() {
        if (this.lock.getAndSet(null) != Thread.currentThread()) {
            throw new IllegalMonitorStateException("WorkSync accidentally released a lock not owned by the current thread");
        }
    }

    private WorkUnit<Material, W> grabBatch() {
        return this.stack.getAndSet(stackEnd);
    }

    private Throwable doSynchronizedWork(WorkUnit<Material, W> batch) {
        W combinedWork = this.combine(batch);
        Throwable failure = null;
        if (combinedWork != null) {
            try {
                combinedWork.apply(this.material);
            }
            catch (Throwable throwable) {
                failure = throwable;
            }
        }
        return failure;
    }

    private W combine(WorkUnit<Material, W> batch) {
        Work result = null;
        while (batch != stackEnd) {
            result = result == null ? (Work)batch.work : result.combine(batch.work);
            WorkUnit tmp = batch.next;
            while (tmp == null) {
                Thread.yield();
                tmp = batch.next;
            }
            batch = tmp;
        }
        return (W)result;
    }

    private void markAsDone(WorkUnit<Material, W> batch) {
        while (batch != stackEnd) {
            batch.complete();
            batch = batch.next;
        }
    }

    private static class WorkUnit<Material, W extends Work<Material, W>>
    extends AtomicInteger {
        static final int STATE_QUEUED = 0;
        static final int STATE_PARKED = 1;
        static final int STATE_DONE = 2;
        final W work;
        final Thread owner;
        volatile WorkUnit<Material, W> next;

        private WorkUnit(W work, Thread owner) {
            this.work = work;
            this.owner = owner;
        }

        void park(long time, TimeUnit unit) {
            if (this.compareAndSet(0, 1)) {
                LockSupport.parkNanos(unit.toNanos(time));
                this.compareAndSet(1, 0);
            }
        }

        boolean isDone() {
            return this.get() == 2;
        }

        void complete() {
            int previousState = this.getAndSet(2);
            if (previousState == 1) {
                this.unpark();
            }
        }

        void unpark() {
            LockSupport.unpark(this.owner);
        }

        /* synthetic */ WorkUnit(Work x0, Thread x1, 1 x2) {
            this(x0, x1);
        }
    }
}

