/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Objects;

public final class FeatureToggles {
    public static boolean flag(Class<?> location, String name, boolean defaultValue) {
        return FeatureToggles.booleanProperty(FeatureToggles.name(location, name), defaultValue);
    }

    public static boolean packageFlag(Class<?> location, String name, boolean defaultValue) {
        return FeatureToggles.booleanProperty(FeatureToggles.name(location.getPackage(), name), defaultValue);
    }

    public static long getLong(Class<?> location, String name, long defaultValue) {
        return Long.getLong(FeatureToggles.name(location, name), defaultValue);
    }

    public static int getInteger(Class<?> location, String name, int defaultValue) {
        return Integer.getInteger(FeatureToggles.name(location, name), defaultValue);
    }

    public static double getDouble(Class<?> location, String name, double defaultValue) {
        try {
            String propertyValue = System.getProperty(FeatureToggles.name(location, name));
            if (propertyValue != null && !propertyValue.isEmpty()) {
                return Double.parseDouble(propertyValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static String getString(Class<?> location, String name, String defaultValue) {
        String propertyValue = System.getProperty(FeatureToggles.name(location, name));
        return propertyValue == null || propertyValue.isEmpty() ? defaultValue : propertyValue;
    }

    public static <E extends Enum<E>> E flag(Class<?> location, String name, E defaultValue) {
        return FeatureToggles.enumProperty(defaultValue.getDeclaringClass(), FeatureToggles.name(location, name), defaultValue);
    }

    public static void set(Class<?> location, String name, Object value) {
        System.setProperty(FeatureToggles.name(location, name), Objects.toString(value));
    }

    public static void clear(Class<?> location, String name) {
        System.clearProperty(FeatureToggles.name(location, name));
    }

    private FeatureToggles() {
    }

    private static String name(Class<?> location, String name) {
        return location.getCanonicalName() + "." + name;
    }

    private static String name(Package location, String name) {
        return location.getName() + "." + name;
    }

    private static boolean booleanProperty(String flag, boolean defaultValue) {
        return FeatureToggles.parseBoolean(System.getProperty(flag), defaultValue);
    }

    private static boolean parseBoolean(String value, boolean defaultValue) {
        return defaultValue ? !"false".equalsIgnoreCase(value) : "true".equalsIgnoreCase(value);
    }

    private static <E extends Enum<E>> E enumProperty(Class<E> enumClass, String name, E defaultValue) {
        try {
            return Enum.valueOf(enumClass, System.getProperty(name, defaultValue.name()));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

