/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.internal.helpers.TimeoutStrategy;

public class DefaultTimeoutStrategy
implements TimeoutStrategy {
    private final Function<Long, Long> increasingFunction;
    private final long startTimeMillis;
    private final long upperBoundTime;

    public static DefaultTimeoutStrategy exponential(long initialTime, long upperBoundTime, TimeUnit timeUnit) {
        return new DefaultTimeoutStrategy(initialTime, upperBoundTime, timeUnit, i -> i * 2L);
    }

    public static DefaultTimeoutStrategy constant(long initialTime, TimeUnit timeUnit) {
        return new DefaultTimeoutStrategy(initialTime, initialTime, timeUnit, i -> i);
    }

    public DefaultTimeoutStrategy(long initialTime, long upperBoundTime, TimeUnit timeUnit, Function<Long, Long> increasingFunction) {
        if (initialTime > increasingFunction.apply(initialTime)) {
            throw new IllegalArgumentException("passed function can't decrease");
        }
        if (initialTime < 0L) {
            throw new IllegalArgumentException("initial time can't be less than zero");
        }
        this.startTimeMillis = timeUnit.toMillis(initialTime);
        this.increasingFunction = increasingFunction;
        this.upperBoundTime = timeUnit.toMillis(upperBoundTime);
    }

    @Override
    public TimeoutStrategy.Timeout newTimeout() {
        return new TimeoutStrategy.Timeout(){
            private long currentTimeMillis;
            {
                this.currentTimeMillis = DefaultTimeoutStrategy.this.startTimeMillis;
            }

            @Override
            public long getMillis() {
                return this.currentTimeMillis;
            }

            @Override
            public void increment() {
                this.currentTimeMillis = Math.min(DefaultTimeoutStrategy.this.upperBoundTime, DefaultTimeoutStrategy.this.increasingFunction.apply(this.currentTimeMillis));
            }
        };
    }
}

