/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.text.StringCharacterIterator;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.kernel.api.exceptions.Status;

public class MemoryLimitExceededException
extends RuntimeException
implements Status.HasStatus {
    private final Status status;

    public MemoryLimitExceededException(long allocation, long limit, long current, Status status, String settingName) {
        super(MemoryLimitExceededException.getMessage(allocation, limit, current, settingName));
        this.status = status;
    }

    @Override
    public Status status() {
        return this.status;
    }

    private static String getMessage(long allocation, long limit, long current, String settingName) {
        if (StringUtils.isEmpty((CharSequence)settingName)) {
            return String.format("The allocation of an extra %s would use more than the limit %s. Currently using %s.", MemoryLimitExceededException.humanReadableByteCountBin(allocation), MemoryLimitExceededException.humanReadableByteCountBin(limit), MemoryLimitExceededException.humanReadableByteCountBin(current));
        }
        return String.format("The allocation of an extra %s would use more than the limit %s. Currently using %s. %s threshold reached", MemoryLimitExceededException.humanReadableByteCountBin(allocation), MemoryLimitExceededException.humanReadableByteCountBin(limit), MemoryLimitExceededException.humanReadableByteCountBin(current), settingName);
    }

    private static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }
}

