/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.helpers.Format;
import org.neo4j.time.SystemNanoClock;

public abstract class Indicator {
    public static final Indicator NONE = new Indicator(1){

        @Override
        protected void progress(int from, int to) {
        }
    };
    private final int reportResolution;

    public Indicator(int reportResolution) {
        this.reportResolution = reportResolution;
    }

    protected abstract void progress(int var1, int var2);

    int reportResolution() {
        return this.reportResolution;
    }

    public void startProcess(long totalCount) {
    }

    public void startPart(String part, long totalCount) {
    }

    public void completePart(String part) {
    }

    public void completeProcess() {
    }

    public void failure(Throwable cause) {
    }

    static class Textual
    extends Indicator {
        static final int DEFAULT_DOTS_PER_LINE = 20;
        static final int DEFAULT_NUM_LINES = 10;
        static final char DEFAULT_DELTA_CHARACTER = '\u2206';
        private final String process;
        private final PrintWriter out;
        private final boolean deltaTimes;
        private final SystemNanoClock clock;
        private final char deltaCharacter;
        private final int dotsPerLine;
        private long lastReportTime;

        Textual(String process, PrintWriter out, boolean deltaTimes, SystemNanoClock clock, char deltaCharacter, int dotsPerLine, int numLines) {
            super(dotsPerLine * numLines);
            this.process = process;
            this.out = out;
            this.deltaTimes = deltaTimes;
            this.clock = clock;
            this.deltaCharacter = deltaCharacter;
            this.dotsPerLine = dotsPerLine;
        }

        @Override
        public void startProcess(long totalCount) {
            this.out.println(this.process);
            this.out.flush();
            this.lastReportTime = this.clock.nanos();
        }

        @Override
        protected void progress(int from, int to) {
            int i = from;
            while (i < to) {
                this.printProgress(++i);
            }
            this.out.flush();
        }

        @Override
        public void failure(Throwable cause) {
            cause.printStackTrace(this.out);
        }

        private void printProgress(int progress) {
            this.out.print('.');
            if (progress % this.dotsPerLine == 0) {
                long currentTime = this.clock.nanos();
                long time = currentTime - this.lastReportTime;
                this.out.printf(" %3d%%", progress * 100 / this.reportResolution());
                if (this.deltaTimes) {
                    this.out.printf(" %c%s", Character.valueOf(this.deltaCharacter), Format.duration(TimeUnit.NANOSECONDS.toMillis(time)));
                }
                this.out.printf("%n", new Object[0]);
                this.lastReportTime = currentTime;
            }
        }
    }
}

