/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.Serializable;
import java.util.List;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.primitive.ImmutableByteObjectMap;
import org.eclipse.collections.impl.factory.primitive.ByteObjectMaps;

public enum KernelVersion {
    V2_3(-10),
    V4_0(1),
    V4_2(2),
    V4_3_D4(3);

    public static final KernelVersion LATEST;
    public static final KernelVersion VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED;
    private static final ImmutableByteObjectMap<KernelVersion> versionMap;
    private final byte version;

    private KernelVersion(byte version) {
        this.version = version;
    }

    public byte version() {
        return this.version;
    }

    public boolean isLatest() {
        return this == LATEST;
    }

    public boolean isGreaterThan(KernelVersion other) {
        return this.version > other.version;
    }

    public boolean isLessThan(KernelVersion other) {
        return this.version < other.version;
    }

    public boolean isAtLeast(KernelVersion other) {
        return this.version >= other.version;
    }

    public String toString() {
        return "KernelVersion{" + this.name() + ",version=" + this.version + "}";
    }

    public static KernelVersion getForVersion(byte version) {
        KernelVersion kernelVersion = (KernelVersion)((Object)versionMap.get(version));
        if (kernelVersion == null) {
            throw new IllegalArgumentException("No matching " + KernelVersion.class.getSimpleName() + " for version " + version);
        }
        return kernelVersion;
    }

    static {
        LATEST = V4_3_D4;
        VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED = V4_3_D4;
        versionMap = ByteObjectMaps.immutable.from(List.of(KernelVersion.values()), KernelVersion::version, (Function & Serializable)v -> v);
    }
}

