/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.common.Validator;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.TimeUtil;

public class Args {
    private static final char OPTION_METADATA_DELIMITER = ':';
    private static final Function<String, Option<String>> DEFAULT_OPTION_PARSER = from -> {
        int metadataStartIndex = from.indexOf(58);
        return metadataStartIndex == -1 ? new Option<String>((String)from, null) : new Option<String>(from.substring(0, metadataStartIndex), from.substring(metadataStartIndex + 1));
    };
    private final String[] args;
    private final String[] flags;
    private final Map<String, List<Option<String>>> map = new HashMap<String, List<Option<String>>>();
    private final List<String> orphans = new ArrayList<String>();

    public static ArgsParser withFlags(String ... flags) {
        return new ArgsParser(flags);
    }

    public static Args parse(String ... args) {
        return Args.withFlags(new String[0]).parse(args);
    }

    private Args(String[] flags, String[] args) {
        this(DEFAULT_OPTION_PARSER, flags, args);
    }

    private Args(Function<String, Option<String>> optionParser, String[] flags, String[] args) {
        this.flags = flags;
        this.args = args;
        this.parseArgs(optionParser, args);
    }

    public Args(Map<String, String> source) {
        this(DEFAULT_OPTION_PARSER, source);
    }

    public Args(Function<String, Option<String>> optionParser, Map<String, String> source) {
        this.flags = new String[0];
        this.args = null;
        for (Map.Entry<String, String> entry : source.entrySet()) {
            this.put(optionParser, entry.getKey(), entry.getValue());
        }
    }

    public String[] source() {
        return this.args;
    }

    public Map<String, String> asMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, List<Option<String>>> entry : this.map.entrySet()) {
            List<Option<String>> values = entry.getValue();
            Option<String> value = values.isEmpty() ? null : values.get(0);
            result.put(entry.getKey(), value != null ? value.value() : null);
        }
        return result;
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public boolean hasNonNull(String key) {
        List<Option<String>> values = this.map.get(key);
        return values != null && !values.isEmpty();
    }

    private String getSingleOptionOrNull(String key) {
        List<Option<String>> values = this.map.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException("There are multiple values for '" + key + "'");
        }
        return values.get(0).value();
    }

    public String get(String key) {
        return this.getSingleOptionOrNull(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.getSingleOptionOrNull(key);
        return value != null ? value : defaultValue;
    }

    public String get(String key, String defaultValueIfNotFound, String defaultValueIfNoValue) {
        String value = this.getSingleOptionOrNull(key);
        if (value != null) {
            return value;
        }
        return this.map.containsKey(key) ? defaultValueIfNoValue : defaultValueIfNotFound;
    }

    public Number getNumber(String key, Number defaultValue) {
        String value = this.getSingleOptionOrNull(key);
        return value != null ? (Number)Double.valueOf(value) : (Number)defaultValue;
    }

    public long getDuration(String key, long defaultValueInMillis) {
        String value = this.getSingleOptionOrNull(key);
        return value != null ? TimeUtil.parseTimeMillis.apply(value) : defaultValueInMillis;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public Boolean getBoolean(String key, Boolean defaultValueIfNotSpecified) {
        return this.getBoolean(key, defaultValueIfNotSpecified, Boolean.TRUE);
    }

    public Boolean getBoolean(String key, Boolean defaultValueIfNotSpecified, Boolean defaultValueIfSpecifiedButNoValue) {
        String value = this.getSingleOptionOrNull(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return this.map.containsKey(key) ? defaultValueIfSpecifiedButNoValue : defaultValueIfNotSpecified;
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumClass, String key, T defaultValue) {
        String raw = this.getSingleOptionOrNull(key);
        if (raw == null) {
            return defaultValue;
        }
        for (Enum candidate : (Enum[])enumClass.getEnumConstants()) {
            if (!candidate.name().equals(raw)) continue;
            return (T)candidate;
        }
        throw new IllegalArgumentException("No enum instance '" + raw + "' in " + enumClass.getName());
    }

    public List<String> orphans() {
        return new ArrayList<String>(this.orphans);
    }

    public String[] orphansAsArray() {
        return this.orphans.toArray(new String[0]);
    }

    public String[] asArgs() {
        ArrayList<CallSite> list = new ArrayList<CallSite>(this.orphans.size());
        for (String string : this.orphans) {
            String quote = string.contains(" ") ? " " : "";
            list.add((CallSite)((Object)(quote + string + quote)));
        }
        for (Map.Entry entry : this.map.entrySet()) {
            for (Option option : (List)entry.getValue()) {
                String key = option.metadata != null ? (String)entry.getKey() + ":" + option.metadata() : (String)entry.getKey();
                String value = (String)option.value();
                String quote = key.contains(" ") || value != null && value.contains(" ") ? " " : "";
                list.add((CallSite)((Object)(quote + (key.length() > 1 ? "--" : "-") + key + (String)(value != null ? "=" + value + quote : ""))));
            }
        }
        return list.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String arg : this.asArgs()) {
            builder.append(builder.length() > 0 ? " " : "").append(arg);
        }
        return builder.toString();
    }

    private static boolean isOption(String arg) {
        return arg.startsWith("-") && arg.length() > 1;
    }

    private boolean isFlag(String arg) {
        return ArrayUtil.contains(this.flags, arg);
    }

    private static boolean isBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    private static String stripOption(String arg) {
        while (!arg.isEmpty() && arg.charAt(0) == '-') {
            arg = arg.substring(1);
        }
        return arg;
    }

    private void parseArgs(Function<String, Option<String>> optionParser, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (Args.isOption(arg)) {
                String value;
                int equalIndex = (arg = Args.stripOption(arg)).indexOf(61);
                if (equalIndex != -1) {
                    String key = arg.substring(0, equalIndex);
                    value = arg.substring(equalIndex + 1);
                    if (value.isEmpty()) continue;
                    this.put(optionParser, key, value);
                    continue;
                }
                if (this.isFlag(arg)) {
                    int nextIndex = i + 1;
                    String string = value = nextIndex < args.length ? args[nextIndex] : null;
                    if (Args.isBoolean(value)) {
                        i = nextIndex;
                        this.put(optionParser, arg, Boolean.valueOf(value).toString());
                        continue;
                    }
                    this.put(optionParser, arg, null);
                    continue;
                }
                int nextIndex = i + 1;
                value = nextIndex < args.length ? args[nextIndex] : null;
                String string = value = value == null || Args.isOption(value) ? null : value;
                if (value != null) {
                    i = nextIndex;
                }
                this.put(optionParser, arg, value);
                continue;
            }
            this.orphans.add(arg);
        }
    }

    private void put(Function<String, Option<String>> optionParser, String key, String value) {
        Option<String> option = optionParser.apply(key);
        List values = this.map.computeIfAbsent(option.value(), k -> new ArrayList());
        values.add(new Option<String>(value, option.metadata()));
    }

    public static String jarUsage(Class<?> main, String ... params) {
        StringBuilder usage = new StringBuilder("USAGE: java [-cp ...] ");
        try {
            String jar = main.getProtectionDomain().getCodeSource().getLocation().getPath();
            usage.append("-jar ").append(jar);
        }
        catch (Exception exception) {
            // empty catch block
        }
        usage.append(' ').append(main.getCanonicalName());
        for (String param : params) {
            usage.append(' ').append(param);
        }
        return usage.toString();
    }

    @SafeVarargs
    public final <T> T interpretOption(String key, Function<String, T> defaultValue, Function<String, T> converter, Validator<T> ... validators) {
        T value;
        if (!this.has(key)) {
            value = defaultValue.apply(key);
        } else {
            String stringValue = this.get(key);
            value = converter.apply(stringValue);
        }
        return this.validated(value, validators);
    }

    @SafeVarargs
    public final <T> Collection<T> interpretOptions(String key, Function<String, T> defaultValue, Function<String, T> converter, Validator<T> ... validators) {
        Collection<Option<T>> options = this.interpretOptionsWithMetadata(key, defaultValue, converter, validators);
        ArrayList<T> values = new ArrayList<T>(options.size());
        for (Option<T> option : options) {
            values.add(option.value());
        }
        return values;
    }

    @SafeVarargs
    public final <T> Collection<Option<T>> interpretOptionsWithMetadata(String key, Function<String, T> defaultValue, Function<String, T> converter, Validator<T> ... validators) {
        ArrayList<Option<T>> values = new ArrayList<Option<T>>();
        if (!this.hasNonNull(key)) {
            T defaultItem = defaultValue.apply(key);
            if (defaultItem != null) {
                values.add(new Option<T>(this.validated(defaultItem, validators), null));
            }
        } else {
            for (Option<String> option : this.map.get(key)) {
                String stringValue = option.value();
                values.add(new Option<T>(this.validated(converter.apply(stringValue), validators), option.metadata()));
            }
        }
        return values;
    }

    @SafeVarargs
    public final <T> T interpretOrphan(int index, Function<String, T> defaultValue, Function<String, T> converter, Validator<T> ... validators) {
        T value;
        assert (index >= 0);
        if (index >= this.orphans.size()) {
            value = defaultValue.apply("argument at index " + index);
        } else {
            String stringValue = this.orphans.get(index);
            value = converter.apply(stringValue);
        }
        return this.validated(value, validators);
    }

    @SafeVarargs
    private <T> T validated(T value, Validator<T> ... validators) {
        if (value != null) {
            for (Validator<T> validator : validators) {
                validator.validate(value);
            }
        }
        return value;
    }

    public static class Option<T> {
        private final T value;
        private final String metadata;

        private Option(T value, String metadata) {
            this.value = value;
            this.metadata = metadata;
        }

        public T value() {
            return this.value;
        }

        public String metadata() {
            return this.metadata;
        }

        public String toString() {
            return "Option[" + this.value + (String)(this.metadata != null ? ", " + this.metadata : "") + "]";
        }
    }

    public static class ArgsParser {
        private final String[] flags;

        private ArgsParser(String ... flags) {
            this.flags = Objects.requireNonNull(flags);
        }

        public Args parse(String ... arguments) {
            return new Args(this.flags, arguments);
        }
    }
}

