/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.neo4j.memory.MemoryTracker;

public class ScopedMemoryTracker
implements MemoryTracker {
    private final MemoryTracker delegate;
    private long trackedNative;
    private long trackedHeap;

    public ScopedMemoryTracker(MemoryTracker delegate) {
        this.delegate = delegate;
    }

    @Override
    public long usedNativeMemory() {
        return this.trackedNative;
    }

    @Override
    public long estimatedHeapMemory() {
        return this.trackedHeap;
    }

    @Override
    public void allocateNative(long bytes) {
        this.delegate.allocateNative(bytes);
        this.trackedNative += bytes;
    }

    @Override
    public void releaseNative(long bytes) {
        this.delegate.releaseNative(bytes);
        this.trackedNative -= bytes;
    }

    @Override
    public void allocateHeap(long bytes) {
        this.delegate.allocateHeap(bytes);
        this.trackedHeap += bytes;
    }

    @Override
    public void releaseHeap(long bytes) {
        this.delegate.releaseHeap(bytes);
        this.trackedHeap -= bytes;
    }

    @Override
    public long heapHighWaterMark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.delegate.releaseNative(this.trackedNative);
        this.delegate.releaseHeap(this.trackedHeap);
        this.trackedNative = 0L;
        this.trackedHeap = 0L;
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        return new ScopedMemoryTracker(this);
    }
}

