/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.OptionalInt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.scheduler.ExecutorServiceFactory;
import org.neo4j.scheduler.SchedulerThreadFactory;

public enum Group {
    TASK_SCHEDULER("Scheduler", ExecutorServiceFactory.unschedulable()),
    PAGE_CACHE_EVICTION("PageCacheEviction"),
    PAGE_CACHE_PRE_FETCHER("PageCachePreFetcher", ExecutorServiceFactory.cachedWithDiscard(), 4),
    FILE_WATCHER("FileWatcher"),
    VM_PAUSE_MONITOR("VmPauseMonitor"),
    LOG_ROTATION("LogRotation"),
    CHECKPOINT("CheckPoint"),
    STORAGE_MAINTENANCE("StorageMaintenance"),
    INDEX_CLEANUP("IndexCleanup"),
    INDEX_CLEANUP_WORK("IndexCleanupWork"),
    TRANSACTION_TIMEOUT_MONITOR("TransactionTimeoutMonitor"),
    INDEX_POPULATION("IndexPopulationMain"),
    INDEX_POPULATION_WORK("IndexPopulationWork", ExecutorServiceFactory.fixedWithBackPressure()),
    INDEX_SAMPLING("IndexSampling"),
    INDEX_UPDATING("IndexUpdating", ExecutorServiceFactory.singleThread()),
    FILE_IO_HELPER("FileIOHelper"),
    NATIVE_SECURITY("NativeSecurity"),
    METRICS_EVENT("MetricsEvent"),
    DATABASE_RECONCILER("DatabaseReconciler"),
    DATABASE_RECONCILER_UNBOUND("DatabaseReconcilerUnbound"),
    DATABASE_ID_REPOSITORY("DatabaseIdRepository"),
    CYPHER_WORKER("CypherWorker", ExecutorServiceFactory.workStealing()),
    DATA_COLLECTOR("DataCollector"),
    BOLT_NETWORK_IO("BoltNetworkIO", ExecutorServiceFactory.unschedulable()),
    BOLT_WORKER("BoltWorker", ExecutorServiceFactory.unschedulable()),
    RAFT_CLIENT("RaftClient"),
    RAFT_SERVER("RaftServer"),
    RAFT_LOG_PRUNING("RaftLogPruning"),
    RAFT_HANDLER("RaftBatchHandler"),
    RAFT_READER_POOL_PRUNER("RaftReaderPoolPruner"),
    LEADER_TRANSFER_SERVICE("LeaderTransferService"),
    CORE_STATE_APPLIER("CoreStateApplier"),
    AKKA_TOPOLOGY_WORKER("AkkaTopologyWorkers", ExecutorServiceFactory.workStealingAsync()),
    DOWNLOAD_SNAPSHOT("DownloadSnapshot"),
    CATCHUP_CLIENT("CatchupClient"),
    CATCHUP_SERVER("CatchupServer"),
    THROUGHPUT_MONITOR("ThroughputMonitor"),
    PANIC_SERVICE("PanicService"),
    SERVER_TRANSACTION_TIMEOUT("ServerTransactionTimeout"),
    PULL_UPDATES("PullUpdates"),
    FABRIC_IDLE_DRIVER_MONITOR("FabricIdleDriverMonitor"),
    FABRIC_WORKER("FabricWorker"),
    TESTING("TestingGroup", ExecutorServiceFactory.callingThread());

    private final String name;
    private final ExecutorServiceFactory executorServiceFactory;
    private final Integer defaultParallelism;
    private final AtomicInteger threadCounter;

    private Group(String name, ExecutorServiceFactory executorServiceFactory, Integer defaultParallelism) {
        this.name = name;
        this.executorServiceFactory = executorServiceFactory;
        this.defaultParallelism = defaultParallelism;
        this.threadCounter = new AtomicInteger();
    }

    private Group(String name, ExecutorServiceFactory executorServiceFactory) {
        this(name, executorServiceFactory, null);
    }

    private Group(String name) {
        this(name, ExecutorServiceFactory.cached());
    }

    public String groupName() {
        return this.name;
    }

    public String threadName() {
        return "neo4j." + this.groupName() + "-" + this.threadCounter.incrementAndGet();
    }

    public ExecutorService buildExecutorService(SchedulerThreadFactory factory, int parallelism) {
        return this.executorServiceFactory.build(this, factory, parallelism);
    }

    public OptionalInt defaultParallelism() {
        return this.defaultParallelism == null ? OptionalInt.empty() : OptionalInt.of(this.defaultParallelism);
    }
}

