/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.helpers.TimeoutStrategy;

public class ConstantTimeTimeoutStrategy
implements TimeoutStrategy {
    private final TimeoutStrategy.Timeout constantTimeout;

    public ConstantTimeTimeoutStrategy(long backoffTime, TimeUnit timeUnit) {
        final long backoffTimeMillis = timeUnit.toMillis(backoffTime);
        this.constantTimeout = new TimeoutStrategy.Timeout(){

            @Override
            public long getMillis() {
                return backoffTimeMillis;
            }

            @Override
            public void increment() {
            }
        };
    }

    public ConstantTimeTimeoutStrategy(Duration backoffTime) {
        this(backoffTime.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public TimeoutStrategy.Timeout newTimeout() {
        return this.constantTimeout;
    }
}

