/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.scheduler.ExecutorServiceFactory;
import org.neo4j.scheduler.SchedulerThreadFactory;

public enum Group {
    TASK_SCHEDULER("Scheduler", ExecutorServiceFactory.unschedulable()),
    PAGE_CACHE("PageCacheWorker"),
    FILE_WATCHER("FileWatcher"),
    VM_PAUSE_MONITOR("VmPauseMonitor"),
    LOG_ROTATION("LogRotation"),
    CHECKPOINT("CheckPoint"),
    STORAGE_MAINTENANCE("StorageMaintenance"),
    TRANSACTION_TIMEOUT_MONITOR("TransactionTimeoutMonitor"),
    INDEX_POPULATION("IndexPopulation"),
    INDEX_SAMPLING("IndexSampling"),
    INDEX_UPDATING("IndexUpdating", ExecutorServiceFactory.singleThread()),
    FILE_IO_HELPER("FileIOHelper"),
    NATIVE_SECURITY("NativeSecurity"),
    METRICS_EVENT("MetricsEvent"),
    DATABASE_RECONCILER("DatabaseReconciler"),
    DATABASE_ID_REPOSITORY("DatabaseIdRepository"),
    CYPHER_WORKER("CypherWorker", ExecutorServiceFactory.workStealing()),
    DATA_COLLECTOR("DataCollector"),
    BOLT_NETWORK_IO("BoltNetworkIO", ExecutorServiceFactory.unschedulable()),
    BOLT_WORKER("BoltWorker", ExecutorServiceFactory.unschedulable()),
    RAFT_CLIENT("RaftClient"),
    RAFT_SERVER("RaftServer"),
    RAFT_TIMER("RaftTimer"),
    RAFT_LOG_PRUNING("RaftLogPruning"),
    RAFT_BATCH_HANDLER("RaftBatchHandler"),
    RAFT_READER_POOL_PRUNER("RaftReaderPoolPruner"),
    AKKA_TOPOLOGY_WORKER("AkkaTopologyWorkers", ExecutorServiceFactory.workStealingAsync()),
    DOWNLOAD_SNAPSHOT("DownloadSnapshot"),
    CATCHUP_CLIENT("CatchupClient"),
    CATCHUP_SERVER("CatchupServer"),
    THROUGHPUT_MONITOR("ThroughputMonitor"),
    PANIC_SERVICE("PanicService"),
    SERVER_TRANSACTION_TIMEOUT("ServerTransactionTimeout"),
    PULL_UPDATES("PullUpdates");

    private final String name;
    private final ExecutorServiceFactory executorServiceFactory;
    private final AtomicInteger threadCounter;

    private Group(String name, ExecutorServiceFactory executorServiceFactory) {
        this.name = name;
        this.executorServiceFactory = executorServiceFactory;
        this.threadCounter = new AtomicInteger();
    }

    private Group(String name) {
        this(name, ExecutorServiceFactory.cached());
    }

    public String groupName() {
        return this.name;
    }

    public String threadName() {
        return "neo4j." + this.groupName() + "-" + this.threadCounter.incrementAndGet();
    }

    public ExecutorService buildExecutorService(SchedulerThreadFactory factory, int parallelism) {
        return this.executorServiceFactory.build(this, factory, parallelism);
    }
}

