/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

public final class Preconditions {
    private Preconditions() {
        throw new AssertionError((Object)"no instances");
    }

    public static long requirePositive(long value) {
        if (value < 1L) {
            throw new IllegalArgumentException("Expected positive long value, got " + value);
        }
        return value;
    }

    public static int requirePositive(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Expected positive int value, got " + value);
        }
        return value;
    }

    public static long requireNonNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Expected non-negative long value, got " + value);
        }
        return value;
    }

    public static int requireExactlyZero(int value) {
        if (value != 0) {
            throw new IllegalArgumentException("Expected long value equal to 0, got " + value);
        }
        return value;
    }

    public static void checkState(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkArgument(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(args.length > 0 ? String.format(message, args) : message);
        }
    }
}

