/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public interface JobScheduler
extends Lifecycle {
    public void setTopLevelGroupName(String var1);

    public Executor executor(Group var1);

    public ExecutorService workStealingExecutor(Group var1, int var2);

    public ThreadFactory threadFactory(Group var1);

    public JobHandle schedule(Group var1, Runnable var2);

    public JobHandle schedule(Group var1, Runnable var2, long var3, TimeUnit var5);

    public JobHandle scheduleRecurring(Group var1, Runnable var2, long var3, TimeUnit var5);

    public JobHandle scheduleRecurring(Group var1, Runnable var2, long var3, long var5, TimeUnit var7);

    public static interface CancelListener {
        public void cancelled(boolean var1);
    }

    public static interface JobHandle {
        public void cancel(boolean var1);

        public void waitTermination() throws InterruptedException, ExecutionException, CancellationException;

        default public void registerCancelListener(CancelListener listener) {
            throw new UnsupportedOperationException("Unsupported in this implementation");
        }
    }

    public static class Groups {
        public static final Group indexPopulation = new Group("IndexPopulation");
        public static final Group masterTransactionPushing = new Group("TransactionPushing");
        public static final Group serverTransactionTimeout = new Group("ServerTransactionTimeout");
        public static final Group slaveLocksTimeout = new Group("SlaveLocksTimeout");
        public static final Group pullUpdates = new Group("PullUpdates");
        public static final Group indexSamplingController = new Group("IndexSamplingController");
        public static final Group indexSampling = new Group("IndexSampling");
        public static final Group internalLogRotation = new Group("InternalLogRotation");
        public static final Group queryLogRotation = new Group("queryLogRotation");
        public static final Group boltLogRotation = new Group("BoltLogRotation");
        public static final Group metricsLogRotations = new Group("MetricsLogRotations");
        public static final Group checkPoint = new Group("CheckPoint");
        public static final Group raftLogPruning = new Group("RaftLogPruning");
        public static final Group boltNetworkIO = new Group("BoltNetworkIO");
        public static final Group metricsEvent = new Group("MetricsEvent");
        public static final Group downloadSnapshot = new Group("DownloadSnapshot");
        public static final Group udc = new Group("UsageDataCollection");
        public static final Group storageMaintenance = new Group("StorageMaintenance");
        public static final Group raft = new Group("RaftTimer");
        public static final Group nativeSecurity = new Group("NativeSecurity");
        public static final Group fileWatch = new Group("FileWatcher");
        public static final Group recoveryCleanup = new Group("RecoveryCleanup");
        public static final Group transactionTimeoutMonitor = new Group("TransactionTimeoutMonitor");
        public static final Group cypherWorker = new Group("CypherWorker");
        public static final Group vmPauseMonitor = new Group("VmPauseMonitor");
        public static final Group pageCacheIOHelper = new Group("PageCacheIOHelper");
        public static Group boltWorker = new Group("BoltWorker");

        private Groups() {
        }
    }

    public static final class Group {
        private final AtomicInteger threadCounter = new AtomicInteger();
        private final String name;

        public Group(String name) {
            Objects.requireNonNull(name, "Group name cannot be null.");
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String threadName() {
            return "neo4j." + this.name() + "-" + this.threadCounter.incrementAndGet();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.name.equals(group.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

