/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.hashing;

import org.neo4j.hashing.IncrementalXXH64;
import org.neo4j.hashing.JavaUtilHashFunction;
import org.neo4j.hashing.XorShift32HashFunction;

public interface HashFunction {
    public long initialise(long var1);

    public long update(long var1, long var3);

    public long finalise(long var1);

    default public int toInt(long hash) {
        return (int)(hash >> 32 ^ hash);
    }

    default public long hashSingleValue(long value) {
        return this.finalise(this.update(this.initialise(0L), value));
    }

    default public int hashSingleValueToInt(long value) {
        return this.toInt(this.hashSingleValue(value));
    }

    public static HashFunction incrementalXXH64() {
        return IncrementalXXH64.INSTANCE;
    }

    public static HashFunction javaUtilHashing() {
        return JavaUtilHashFunction.INSTANCE;
    }

    public static HashFunction xorShift32() {
        return XorShift32HashFunction.INSTANCE;
    }
}

