/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.neo4j.memory.GlobalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.memory.MemoryTracker;

public class LocalMemoryTracker
implements MemoryTracker,
MemoryAllocationTracker {
    private long allocatedBytes;
    private GlobalMemoryTracker globalTracker = GlobalMemoryTracker.INSTANCE;

    @Override
    public void allocate(long allocatedBytes) {
        this.globalTracker.allocate(allocatedBytes);
        this.allocatedBytes += allocatedBytes;
    }

    @Override
    public void deallocate(long deallocatedBytes) {
        this.globalTracker.deallocate(deallocatedBytes);
        this.allocatedBytes -= deallocatedBytes;
    }

    @Override
    public long usedDirectMemory() {
        return this.allocatedBytes;
    }
}

