/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public interface Status {
    public Code code();

    public static Status statusCodeOf(Throwable e) {
        do {
            if (!(e instanceof HasStatus)) continue;
            return ((HasStatus)((Object)e)).status();
        } while ((e = e.getCause()) != null);
        return null;
    }

    public static interface HasStatus {
        public Status status();
    }

    public static enum Classification {
        ClientError(TransactionEffect.ROLLBACK, "The Client sent a bad request - changing the request might yield a successful outcome."),
        ClientNotification(TransactionEffect.NONE, "There are notifications about the request sent by the client."),
        TransientError(TransactionEffect.ROLLBACK, "The database cannot service the request right now, retrying later might yield a successful outcome. "),
        DatabaseError(TransactionEffect.ROLLBACK, "The database failed to service the request. ");

        private final boolean rollbackTransaction;
        private final String description;

        private Classification(TransactionEffect transactionEffect, String description) {
            this.description = description;
            this.rollbackTransaction = transactionEffect == TransactionEffect.ROLLBACK;
        }

        public boolean rollbackTransaction() {
            return this.rollbackTransaction;
        }

        public String description() {
            return this.description;
        }

        private static enum TransactionEffect {
            ROLLBACK,
            NONE;

        }
    }

    public static class Code {
        private final Classification classification;
        private final String description;
        private final String category;
        private final String title;

        public static Collection<Status> all() {
            ArrayList<Status> result = new ArrayList<Status>();
            for (Class<?> child : Status.class.getDeclaredClasses()) {
                if (!child.isEnum() || !Status.class.isAssignableFrom(child)) continue;
                Class<?> statusType = child;
                Collections.addAll(result, statusType.getEnumConstants());
            }
            return result;
        }

        <C extends Enum<C>> Code(Classification classification, C categoryAndTitle, String description) {
            this.classification = classification;
            this.category = categoryAndTitle.getDeclaringClass().getSimpleName();
            this.title = categoryAndTitle.name();
            this.description = description;
        }

        public String toString() {
            return "Status.Code[" + this.serialize() + "]";
        }

        public final String serialize() {
            return String.format("Neo.%s.%s.%s", new Object[]{this.classification, this.category, this.title});
        }

        public final String description() {
            return this.description;
        }

        public Classification classification() {
            return this.classification;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Code code = (Code)o;
            return this.category.equals(code.category) && this.classification == code.classification && this.title.equals(code.title);
        }

        public int hashCode() {
            int result = this.classification.hashCode();
            result = 31 * result + this.category.hashCode();
            result = 31 * result + this.title.hashCode();
            return result;
        }
    }

    public static enum Cluster implements Status
    {
        NoLeaderAvailable(Classification.TransientError, "No leader available at the moment. Retrying your request at a later time may succeed."),
        NotALeader(Classification.ClientError, "The request cannot be processed by this server. Write requests can only be processed by the leader.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Cluster(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum General implements Status
    {
        InvalidArguments(Classification.ClientError, "The request contained fields that were empty or are not allowed."),
        ForbiddenOnReadOnlyDatabase(Classification.ClientError, "This is a read only database, writing or modifying the database is not allowed."),
        IndexCorruptionDetected(Classification.DatabaseError, "The request (directly or indirectly) referred to an index that is in a failed state. The index needs to be dropped and recreated manually."),
        SchemaCorruptionDetected(Classification.DatabaseError, "A malformed schema rule was encountered. Please contact your support representative."),
        StorageDamageDetected(Classification.DatabaseError, "Expected set of files not found on disk. Please restore from backup."),
        UnknownError(Classification.DatabaseError, "An unknown error occurred."),
        OutOfMemoryError(Classification.TransientError, "There is not enough memory to perform the current task. Please try increasing 'dbms.memory.heap.max_size' in the neo4j configuration (normally in 'conf/neo4j.conf' or, if you you are using Neo4j Desktop, found through the user interface) or if you are running an embedded installation increase the heap by using '-Xmx' command line flag, and then restart the database."),
        StackOverFlowError(Classification.TransientError, "There is not enough stack size to perform the current task. This is generally considered to be a database error, so please contact Neo4j support. You could try increasing the stack size: for example to set the stack size to 2M, add `dbms.jvm.additional=-Xss2M' to in the neo4j configuration (normally in 'conf/neo4j.conf' or, if you are using Neo4j Desktop, found through the user interface) or if you are running an embedded installation just add -Xss2M as command line flag."),
        DatabaseUnavailable(Classification.TransientError, "The database is not currently available to serve your request, refer to the database logs for more details. Retrying your request at a later time may succeed.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private General(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Security implements Status
    {
        CredentialsExpired(Classification.ClientError, "The credentials have expired and need to be updated."),
        Unauthorized(Classification.ClientError, "The client is unauthorized due to authentication failure."),
        AuthenticationRateLimit(Classification.ClientError, "The client has provided incorrect authentication details too many times in a row."),
        ModifiedConcurrently(Classification.TransientError, "The user was modified concurrently to this request."),
        EncryptionRequired(Classification.ClientError, "A TLS encrypted connection is required."),
        Forbidden(Classification.ClientError, "An attempt was made to perform an unauthorized action."),
        AuthorizationExpired(Classification.ClientError, "The stored authorization info has expired. Please reconnect."),
        AuthProviderTimeout(Classification.TransientError, "An auth provider request timed out."),
        AuthProviderFailed(Classification.TransientError, "An auth provider request failed.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Security(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Procedure implements Status
    {
        ProcedureRegistrationFailed(Classification.ClientError, "The database failed to register a procedure, refer to the associated error message for details."),
        ProcedureNotFound(Classification.ClientError, "A request referred to a procedure that is not registered with this database instance. If you are deploying custom procedures in a cluster setup, ensure all instances in the cluster have the procedure jar file deployed."),
        ProcedureCallFailed(Classification.ClientError, "Failed to invoke a procedure. See the detailed error description for exact cause."),
        TypeError(Classification.ClientError, "A procedure is using or receiving a value of an invalid type."),
        ProcedureTimedOut(Classification.ClientError, "The procedure has not completed within the specified timeout. You may want to retry with a longer timeout."),
        ProcedureWarning(Classification.ClientNotification, "The query used a procedure that generated a warning.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Procedure(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum LegacyIndex implements Status
    {
        LegacyIndexNotFound(Classification.ClientError, "The request (directly or indirectly) referred to an explicit index that does not exist.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private LegacyIndex(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Schema implements Status
    {
        RepeatedPropertyInCompositeSchema(Classification.ClientError, "Unable to create composite index or constraint because a property was specified in several positions."),
        ConstraintAlreadyExists(Classification.ClientError, "Unable to perform operation because it would clash with a pre-existing constraint."),
        ConstraintNotFound(Classification.ClientError, "The request (directly or indirectly) referred to a constraint that does not exist."),
        ConstraintValidationFailed(Classification.ClientError, "A constraint imposed by the database was violated."),
        ConstraintVerificationFailed(Classification.ClientError, "Unable to create constraint because data that exists in the database violates it."),
        IndexAlreadyExists(Classification.ClientError, "Unable to perform operation because it would clash with a pre-existing index."),
        IndexNotFound(Classification.ClientError, "The request (directly or indirectly) referred to an index that does not exist."),
        IndexNotApplicable(Classification.ClientError, "The request did not contain the properties required by the index."),
        ForbiddenOnConstraintIndex(Classification.ClientError, "A requested operation can not be performed on the specified index because the index is part of a constraint. If you want to drop the index, for instance, you must drop the constraint."),
        TokenNameError(Classification.ClientError, "A token name, such as a label, relationship type or property key, used is not valid. Tokens cannot be empty strings and cannot be null."),
        ConstraintCreationFailed(Classification.DatabaseError, "Creating a requested constraint failed."),
        ConstraintDropFailed(Classification.DatabaseError, "The database failed to drop a requested constraint."),
        IndexCreationFailed(Classification.DatabaseError, "Failed to create an index."),
        IndexDropFailed(Classification.DatabaseError, "The database failed to drop a requested index."),
        LabelAccessFailed(Classification.DatabaseError, "The request accessed a label that did not exist."),
        LabelLimitReached(Classification.DatabaseError, "The maximum number of labels supported has been reached, no more labels can be created."),
        PropertyKeyAccessFailed(Classification.DatabaseError, "The request accessed a property that does not exist."),
        RelationshipTypeAccessFailed(Classification.DatabaseError, "The request accessed a relationship type that does not exist."),
        SchemaRuleAccessFailed(Classification.DatabaseError, "The request referred to a schema rule that does not exist."),
        SchemaRuleDuplicateFound(Classification.DatabaseError, "The request referred to a schema rule that is defined multiple times."),
        SchemaModifiedConcurrently(Classification.TransientError, "The database schema was modified while this transaction was running, the transaction should be retried.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Schema(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Statement implements Status
    {
        SyntaxError(Classification.ClientError, "The statement contains invalid or unsupported syntax."),
        SemanticError(Classification.ClientError, "The statement is syntactically valid, but expresses something that the database cannot do."),
        ParameterMissing(Classification.ClientError, "The statement refers to a parameter that was not provided in the request."),
        ConstraintVerificationFailed(Classification.ClientError, "A constraint imposed by the statement is violated by the data in the database."),
        EntityNotFound(Classification.ClientError, "The statement refers to a non-existent entity."),
        PropertyNotFound(Classification.ClientError, "The statement refers to a non-existent property."),
        LabelNotFound(Classification.ClientError, "The statement is referring to a label that does not exist."),
        TypeError(Classification.ClientError, "The statement is attempting to perform operations on values with types that are not supported by the operation."),
        ArgumentError(Classification.ClientError, "The statement is attempting to perform operations using invalid arguments"),
        ArithmeticError(Classification.ClientError, "Invalid use of arithmetic, such as dividing by zero."),
        ExecutionFailed(Classification.DatabaseError, "The database was unable to execute the statement."),
        ExternalResourceFailed(Classification.ClientError, "Access to an external resource failed"),
        CartesianProductWarning(Classification.ClientNotification, "This query builds a cartesian product between disconnected patterns."),
        DynamicPropertyWarning(Classification.ClientNotification, "Queries using dynamic properties will use neither index seeks nor index scans for those properties"),
        EagerOperatorWarning(Classification.ClientNotification, "The execution plan for this query contains the Eager operator, which forces all dependent data to be materialized in main memory before proceeding"),
        JoinHintUnfulfillableWarning(Classification.ClientNotification, "The database was unable to plan a hinted join."),
        NoApplicableIndexWarning(Classification.ClientNotification, "Adding a schema index may speed up this query."),
        UnboundedVariableLengthPatternWarning(Classification.ClientNotification, "The provided pattern is unbounded, consider adding an upper limit to the number of node hops."),
        ExhaustiveShortestPathWarning(Classification.ClientNotification, "Exhaustive shortest path has been planned for your query that means that shortest path graph algorithm might not be used to find the shortest path. Hence an exhaustive enumeration of all paths might be used in order to find the requested shortest path."),
        PlannerUnavailableWarning(Classification.ClientNotification, "The RULE planner is not available in the current CYPHER version, the query has been run by an older CYPHER version."),
        PlannerUnsupportedWarning(Classification.ClientNotification, "This query is not supported by the COST planner."),
        RuntimeUnsupportedWarning(Classification.ClientNotification, "This query is not supported by the chosen runtime."),
        FeatureDeprecationWarning(Classification.ClientNotification, "This feature is deprecated and will be removed in future versions."),
        ExperimentalFeature(Classification.ClientNotification, "This feature is experimental and should not be used in production systems."),
        JoinHintUnsupportedWarning(Classification.ClientNotification, "Queries with join hints are not supported by the RULE planner."),
        UnknownLabelWarning(Classification.ClientNotification, "The provided label is not in the database."),
        UnknownRelationshipTypeWarning(Classification.ClientNotification, "The provided relationship type is not in the database."),
        UnknownPropertyKeyWarning(Classification.ClientNotification, "The provided property key is not in the database"),
        CreateUniqueUnavailableWarning(Classification.ClientNotification, "CREATE UNIQUE is not available in the current CYPHER version, the query has been run by an older CYPHER version.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Statement(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Transaction implements Status
    {
        TransactionNotFound(Classification.ClientError, "The request referred to a transaction that does not exist."),
        TransactionAccessedConcurrently(Classification.ClientError, "There were concurrent requests accessing the same transaction, which is not allowed."),
        ForbiddenDueToTransactionType(Classification.ClientError, "The transaction is of the wrong type to service the request. For instance, a transaction that has had schema modifications performed in it cannot be used to subsequently perform data operations, and vice versa."),
        TransactionValidationFailed(Classification.ClientError, "Transaction changes did not pass validation checks"),
        TransactionHookFailed(Classification.ClientError, "Transaction hook failure."),
        TransactionMarkedAsFailed(Classification.ClientError, "Transaction was marked as both successful and failed. Failure takes precedence and so this transaction was rolled back although it may have looked like it was going to be committed"),
        TransactionTimedOut(Classification.ClientError, "The transaction has not completed within the specified timeout. You may want to retry with a longer timeout."),
        InvalidBookmark(Classification.ClientError, "Supplied bookmark cannot be interpreted. You should only supply a bookmark previously that was previously generated by Neo4j. Maybe you have generated your own bookmark, or modified a bookmark since it was generated by Neo4j."),
        TransactionStartFailed(Classification.DatabaseError, "The database was unable to start the transaction."),
        TransactionRollbackFailed(Classification.DatabaseError, "The database was unable to roll back the transaction."),
        TransactionCommitFailed(Classification.DatabaseError, "The database was unable to commit the transaction."),
        TransactionLogError(Classification.DatabaseError, "The database was unable to write transaction to log."),
        LockSessionExpired(Classification.TransientError, "The lock session under which this transaction was started is no longer valid."),
        DeadlockDetected(Classification.TransientError, "This transaction, and at least one more transaction, has acquired locks in a way that it will wait indefinitely, and the database has aborted it. Retrying this transaction will most likely be successful."),
        InstanceStateChanged(Classification.TransientError, "Transactions rely on assumptions around the state of the Neo4j instance they execute on. For instance, transactions in a cluster may expect that they are executing on an instance that can perform writes. However, instances may change state while the transaction is running. This causes assumptions the instance has made about how to execute the transaction to be violated - meaning the transaction must be rolled back. If you see this error, you should retry your operation in a new transaction."),
        ConstraintsChanged(Classification.TransientError, "Database constraints changed since the start of this transaction"),
        Outdated(Classification.TransientError, "Transaction has seen state which has been invalidated by applied updates while transaction was active. Transaction may succeed if retried."),
        LockClientStopped(Classification.TransientError, "The transaction has been terminated, so no more locks can be acquired. This can occur because the transaction ran longer than the configured transaction timeout, or because a human operator manually terminated the transaction, or because the database is shutting down."),
        LockAcquisitionTimeout(Classification.TransientError, "Unable to acquire lock within configured timeout."),
        Terminated(Classification.TransientError, "Explicitly terminated by the user."),
        Interrupted(Classification.TransientError, "Interrupted while waiting.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Transaction(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Request implements Status
    {
        Invalid(Classification.ClientError, "The client provided an invalid request."),
        InvalidFormat(Classification.ClientError, "The client provided a request that was missing required fields, or had values that are not allowed."),
        TransactionRequired(Classification.ClientError, "The request cannot be performed outside of a transaction, and there is no transaction present to use. Wrap your request in a transaction and retry."),
        InvalidUsage(Classification.ClientError, "The client made a request but did not consume outgoing buffers in a timely fashion.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Request(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Network implements Status
    {
        CommunicationError(Classification.TransientError, "An unknown network failure occurred, a retry may resolve the issue.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Network(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }
}

