/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Objects;

public abstract class HeapAllocation {
    public static final HeapAllocation HEAP_ALLOCATION;
    public static final HeapAllocation NOT_AVAILABLE;

    public final long allocatedBytes(Thread thread) {
        return this.allocatedBytes(thread.getId());
    }

    public abstract long allocatedBytes(long var1);

    private static HeapAllocation load(ThreadMXBean bean) {
        Class<HeapAllocation> base = HeapAllocation.class;
        StringBuilder name = new StringBuilder().append(base.getPackage().getName()).append('.');
        String pkg = bean.getClass().getPackage().getName();
        int start = 0;
        int end = pkg.indexOf(46, start);
        while (end > 0) {
            name.append(Character.toUpperCase(pkg.charAt(start))).append(pkg.substring(start + 1, end));
            start = end + 1;
            end = pkg.indexOf(46, start);
        }
        name.append(Character.toUpperCase(pkg.charAt(start))).append(pkg.substring(start + 1));
        name.append(base.getSimpleName());
        try {
            return Objects.requireNonNull((HeapAllocation)Class.forName(name.toString()).getDeclaredMethod("load", ThreadMXBean.class).invoke(null, bean), "Loader method returned null.");
        }
        catch (Throwable e) {
            if (NOT_AVAILABLE == null) {
                throw new LinkageError("Bad code loading order.", e);
            }
            return NOT_AVAILABLE;
        }
    }

    static {
        NOT_AVAILABLE = new HeapAllocationNotAvailable();
        HEAP_ALLOCATION = HeapAllocation.load(ManagementFactory.getThreadMXBean());
    }

    private static class HeapAllocationNotAvailable
    extends HeapAllocation {
        private HeapAllocationNotAvailable() {
        }

        @Override
        public long allocatedBytes(long threadId) {
            return -1L;
        }
    }
}

