/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class LifeSupport
implements Lifecycle {
    private volatile List<LifecycleInstance> instances = new ArrayList<LifecycleInstance>();
    private volatile LifecycleStatus status = LifecycleStatus.NONE;
    private final List<LifecycleListener> listeners = new ArrayList<LifecycleListener>();

    @Override
    public synchronized void init() throws LifecycleException {
        if (this.status == LifecycleStatus.NONE) {
            this.status = this.changedStatus(this, this.status, LifecycleStatus.INITIALIZING);
            for (LifecycleInstance instance : this.instances) {
                try {
                    instance.init();
                }
                catch (LifecycleException e) {
                    this.status = this.changedStatus(this, this.status, LifecycleStatus.STOPPED);
                    try {
                        this.shutdown();
                    }
                    catch (LifecycleException shutdownErr) {
                        e.addSuppressed(shutdownErr);
                    }
                    throw e;
                }
            }
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STOPPED);
        }
    }

    @Override
    public synchronized void start() throws LifecycleException {
        this.init();
        if (this.status == LifecycleStatus.STOPPED) {
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STARTING);
            for (LifecycleInstance instance : this.instances) {
                try {
                    instance.start();
                }
                catch (LifecycleException e) {
                    this.status = this.changedStatus(this, this.status, LifecycleStatus.STARTED);
                    try {
                        this.stop();
                    }
                    catch (LifecycleException stopErr) {
                        e.addSuppressed(stopErr);
                    }
                    throw e;
                }
            }
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STARTED);
        }
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        if (this.status == LifecycleStatus.STARTED) {
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STOPPING);
            LifecycleException ex = this.stopInstances(this.instances);
            this.status = this.changedStatus(this, this.status, LifecycleStatus.STOPPED);
            if (ex != null) {
                throw ex;
            }
        }
    }

    private LifecycleException stopInstances(List<LifecycleInstance> instances) {
        LifecycleException ex = null;
        for (int i = instances.size() - 1; i >= 0; --i) {
            LifecycleInstance lifecycleInstance = instances.get(i);
            try {
                lifecycleInstance.stop();
                continue;
            }
            catch (LifecycleException e) {
                if (ex != null) {
                    ex.addSuppressed(e);
                    continue;
                }
                ex = e;
            }
        }
        return ex;
    }

    @Override
    public synchronized void shutdown() throws LifecycleException {
        LifecycleException ex = null;
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            ex = e;
        }
        if (this.status == LifecycleStatus.STOPPED) {
            this.status = this.changedStatus(this, this.status, LifecycleStatus.SHUTTING_DOWN);
            for (int i = this.instances.size() - 1; i >= 0; --i) {
                LifecycleInstance lifecycleInstance = this.instances.get(i);
                try {
                    lifecycleInstance.shutdown();
                    continue;
                }
                catch (LifecycleException e) {
                    if (ex != null) {
                        ex.addSuppressed(e);
                        continue;
                    }
                    ex = e;
                }
            }
            this.status = this.changedStatus(this, this.status, LifecycleStatus.SHUTDOWN);
            if (ex != null) {
                throw ex;
            }
        }
    }

    public synchronized <T extends Lifecycle> T add(T instance) throws LifecycleException {
        assert (instance != null);
        assert (this.notAlreadyAdded(instance));
        LifecycleInstance newInstance = new LifecycleInstance(instance);
        ArrayList<LifecycleInstance> tmp = new ArrayList<LifecycleInstance>(this.instances);
        tmp.add(newInstance);
        this.instances = tmp;
        this.bringToState(newInstance);
        return instance;
    }

    private boolean notAlreadyAdded(Lifecycle instance) {
        for (LifecycleInstance candidate : this.instances) {
            if (candidate.instance != instance) continue;
            throw new IllegalStateException(instance + " already added", candidate.addedWhere);
        }
        return true;
    }

    public synchronized boolean remove(Lifecycle instance) {
        for (int i = 0; i < this.instances.size(); ++i) {
            if (!this.instances.get(i).isInstance(instance)) continue;
            ArrayList<LifecycleInstance> tmp = new ArrayList<LifecycleInstance>(this.instances);
            LifecycleInstance lifecycleInstance = (LifecycleInstance)tmp.remove(i);
            lifecycleInstance.shutdown();
            this.instances = tmp;
            return true;
        }
        return false;
    }

    public Iterable<Lifecycle> getLifecycleInstances() {
        return this.instances.stream().map(l -> l.instance).collect(Collectors.toList());
    }

    public synchronized void clear() {
        for (LifecycleInstance instance : this.instances) {
            instance.shutdown();
        }
        this.instances = new ArrayList<LifecycleInstance>();
    }

    public LifecycleStatus getStatus() {
        return this.status;
    }

    public synchronized void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    private void bringToState(LifecycleInstance instance) throws LifecycleException {
        switch (this.status) {
            case STARTED: {
                instance.start();
                break;
            }
            case STOPPED: {
                instance.init();
                break;
            }
        }
    }

    private LifecycleStatus changedStatus(Lifecycle instance, LifecycleStatus oldStatus, LifecycleStatus newStatus) {
        for (LifecycleListener listener : this.listeners) {
            listener.notifyStatusChanged(instance, oldStatus, newStatus);
        }
        return newStatus;
    }

    public boolean isRunning() {
        return this.status == LifecycleStatus.STARTED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(0, sb);
        return sb.toString();
    }

    private void toString(int indent, StringBuilder sb) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        sb.append("Lifecycle status:" + this.status.name()).append('\n');
        for (LifecycleInstance instance : this.instances) {
            if (instance.instance instanceof LifeSupport) {
                ((LifeSupport)instance.instance).toString(indent + 3, sb);
                continue;
            }
            for (int i = 0; i < indent + 3; ++i) {
                sb.append(' ');
            }
            sb.append(instance.toString()).append('\n');
        }
    }

    private class LifecycleInstance
    implements Lifecycle {
        Lifecycle instance;
        LifecycleStatus currentStatus = LifecycleStatus.NONE;
        Exception addedWhere;

        private LifecycleInstance(Lifecycle instance) {
            this.instance = instance;
            assert (this.trackInstantiationStackTrace());
        }

        private boolean trackInstantiationStackTrace() {
            this.addedWhere = new Exception();
            return true;
        }

        @Override
        public void init() throws LifecycleException {
            if (this.currentStatus == LifecycleStatus.NONE) {
                this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.INITIALIZING);
                try {
                    this.instance.init();
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STOPPED);
                }
                catch (Throwable e) {
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.NONE);
                    try {
                        this.instance.shutdown();
                    }
                    catch (Throwable se) {
                        e.addSuppressed(se);
                    }
                    if (e instanceof LifecycleException) {
                        throw (LifecycleException)e;
                    }
                    throw new LifecycleException(this.instance, LifecycleStatus.NONE, LifecycleStatus.STOPPED, e);
                }
            }
        }

        @Override
        public void start() throws LifecycleException {
            if (this.currentStatus == LifecycleStatus.NONE) {
                this.init();
            }
            if (this.currentStatus == LifecycleStatus.STOPPED) {
                this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STARTING);
                try {
                    this.instance.start();
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STARTED);
                }
                catch (Throwable e) {
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STOPPED);
                    try {
                        this.instance.stop();
                    }
                    catch (Throwable se) {
                        e.addSuppressed(se);
                    }
                    if (e instanceof LifecycleException) {
                        throw (LifecycleException)e;
                    }
                    throw new LifecycleException(this.instance, LifecycleStatus.STOPPED, LifecycleStatus.STARTED, e);
                }
            }
        }

        @Override
        public void stop() throws LifecycleException {
            if (this.currentStatus == LifecycleStatus.STARTED) {
                this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STOPPING);
                try {
                    this.instance.stop();
                }
                catch (LifecycleException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new LifecycleException(this.instance, LifecycleStatus.STARTED, LifecycleStatus.STOPPED, e);
                }
                finally {
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.STOPPED);
                }
            }
        }

        @Override
        public void shutdown() throws LifecycleException {
            if (this.currentStatus == LifecycleStatus.STARTED) {
                this.stop();
            }
            if (this.currentStatus == LifecycleStatus.STOPPED) {
                this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.SHUTTING_DOWN);
                try {
                    this.instance.shutdown();
                }
                catch (LifecycleException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new LifecycleException(this.instance, LifecycleStatus.STOPPED, LifecycleStatus.SHUTTING_DOWN, e);
                }
                finally {
                    this.currentStatus = LifeSupport.this.changedStatus(this.instance, this.currentStatus, LifecycleStatus.SHUTDOWN);
                }
            }
        }

        public String toString() {
            return this.instance.toString() + ": " + this.currentStatus.name();
        }

        public boolean isInstance(Lifecycle instance) {
            return this.instance == instance;
        }
    }
}

