/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.time;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.neo4j.time.SystemNanoClock;

public class FakeClock
extends SystemNanoClock {
    private long nanoTime = 0L;

    protected FakeClock() {
    }

    protected FakeClock(long initialTime, TimeUnit unit) {
        this.forward(initialTime, unit);
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(TimeUnit.NANOSECONDS.toMillis(this.nanoTime));
    }

    @Override
    public long nanos() {
        return this.nanoTime;
    }

    @Override
    public long millis() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanoTime);
    }

    public FakeClock forward(long delta, TimeUnit unit) {
        this.nanoTime += unit.toNanos(delta);
        return this;
    }
}

