/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.internal.helpers.progress.Aggregator;
import org.neo4j.internal.helpers.progress.BasicTextualIndicator;
import org.neo4j.internal.helpers.progress.Indicator;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.TextualIndicator;
import org.neo4j.time.Clocks;
import org.neo4j.util.Preconditions;

public abstract class ProgressMonitorFactory {
    public static final ProgressMonitorFactory NONE = new ProgressMonitorFactory(){

        @Override
        protected Indicator newIndicator(String process) {
            return Indicator.NONE;
        }
    };
    public static final IndicatorListener NO_INDICATOR_LISTENER = (progress, total) -> {};

    public static ProgressMonitorFactory textual(OutputStream out) {
        return ProgressMonitorFactory.textual(new OutputStreamWriter(out, StandardCharsets.UTF_8), false, 20, 1, 10);
    }

    public static ProgressMonitorFactory basicTextual(Writer out) {
        return ProgressMonitorFactory.basicTextual(out, 100, 10, " %3d%% completed");
    }

    public static ProgressMonitorFactory textual(Writer out) {
        return ProgressMonitorFactory.textual(out, false, 20, 1, 10);
    }

    public static ProgressMonitorFactory textual(OutputStream out, boolean deltaTimes, int dotsPerGroup, int groupsPerLine, int numLines) {
        return ProgressMonitorFactory.textual(new OutputStreamWriter(out, StandardCharsets.UTF_8), deltaTimes, dotsPerGroup, groupsPerLine, numLines);
    }

    public static ProgressMonitorFactory textual(final Writer out, final boolean deltaTimes, final int dotsPerGroup, final int groupsPerLine, final int numLines) {
        return new ProgressMonitorFactory(){

            @Override
            protected Indicator newIndicator(String process) {
                return new TextualIndicator(process, this.writer(), deltaTimes, Clocks.nanoClock(), '\u2206', dotsPerGroup, groupsPerLine, numLines);
            }

            private PrintWriter writer() {
                PrintWriter pw;
                return out instanceof PrintWriter ? (pw = (PrintWriter)out) : new PrintWriter(out);
            }
        };
    }

    public static ProgressMonitorFactory basicTextual(final Writer out, final int resolution, final int step, final String displayText) {
        return new ProgressMonitorFactory(){

            @Override
            protected Indicator newIndicator(String process) {
                return new BasicTextualIndicator(this.writer(), resolution, step, displayText);
            }

            private PrintWriter writer() {
                PrintWriter pw;
                return out instanceof PrintWriter ? (pw = (PrintWriter)out) : new PrintWriter(out);
            }
        };
    }

    public static ProgressMonitorFactory mapped(final ProgressListener target, final int resolution) {
        return new ProgressMonitorFactory(){

            @Override
            protected Indicator newIndicator(String process) {
                return new Indicator(resolution){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void progress(int from, int to) {
                        ProgressListener progressListener = target;
                        synchronized (progressListener) {
                            target.add(to - from);
                        }
                    }
                };
            }
        };
    }

    public static ProgressMonitorFactory mappedFraction(ProgressListener target, float resolutionFraction) {
        Preconditions.checkArgument(resolutionFraction > 0.0f && resolutionFraction <= 1.0f, "Require 0 < progressFraction <= 1");
        int resolution = (int)((float)target.reportResolution() * resolutionFraction);
        return ProgressMonitorFactory.mapped(target, resolution);
    }

    public MultiPartBuilder multipleParts(String process, IndicatorListener listener) {
        return new MultiPartBuilder(this.newIndicator(process), listener);
    }

    public final MultiPartBuilder multipleParts(String process) {
        return this.multipleParts(process, NO_INDICATOR_LISTENER);
    }

    public final ProgressListener singlePart(String process, long totalCount, IndicatorListener listener) {
        return new ProgressListener.SinglePartProgressListener(this.newIndicator(process), totalCount, listener);
    }

    public ProgressListener singlePart(String process, long totalCount) {
        return this.singlePart(process, totalCount, NO_INDICATOR_LISTENER);
    }

    protected abstract Indicator newIndicator(String var1);

    public static class MultiPartBuilder {
        private Aggregator aggregator;
        private Set<String> parts = new HashSet<String>();

        private MultiPartBuilder(Indicator indicator, IndicatorListener listener) {
            this.aggregator = new Aggregator(indicator, listener);
        }

        public ProgressListener progressForPart(String part, long totalCount) {
            this.assertNotBuilt();
            this.assertUniquePart(part);
            ProgressListener.MultiPartProgressListener progress = new ProgressListener.MultiPartProgressListener(this.aggregator, part, totalCount);
            this.aggregator.add(progress, totalCount);
            return progress;
        }

        private void assertUniquePart(String part) {
            if (!this.parts.add(part)) {
                throw new IllegalArgumentException(String.format("Part '%s' has already been defined.", part));
            }
        }

        private void assertNotBuilt() {
            if (this.aggregator == null) {
                throw new IllegalStateException("Builder has been completed.");
            }
        }

        public Completer build() {
            Preconditions.checkState(this.aggregator != null, "Already built");
            Completer completer = this.aggregator.initialize();
            this.aggregator = null;
            this.parts = null;
            return completer;
        }

        public void done() {
            this.aggregator.done();
        }
    }

    public static interface IndicatorListener {
        public void update(long var1, long var3);
    }

    public static abstract class PercentageIndicatorListener
    implements IndicatorListener {
        private final int percentageStride;
        private int lastReportedPercentage;

        public PercentageIndicatorListener(int percentageStride) {
            this.percentageStride = percentageStride;
        }

        @Override
        public void update(long progress, long total) {
            int percentage = Math.toIntExact((long)((double)progress * 100.0 / (double)total));
            while (this.lastReportedPercentage < percentage) {
                ++this.lastReportedPercentage;
                if (this.lastReportedPercentage % this.percentageStride != 0 && this.lastReportedPercentage != 100) continue;
                this.percentage(this.lastReportedPercentage);
            }
        }

        public abstract void percentage(int var1);
    }

    public static interface Completer
    extends AutoCloseable {
        @Override
        public void close();
    }
}

