/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.text.StringCharacterIterator;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class MemoryLimitExceededException
extends GqlRuntimeException
implements Status.HasStatus {
    private final Status status;
    private final String settingName;

    private MemoryLimitExceededException(ErrorGqlStatusObject gqlStatusObject, Status status, String settingName, String message) {
        super(gqlStatusObject, message);
        this.status = status;
        this.settingName = settingName;
    }

    public static MemoryLimitExceededException memoryPoolOutOfMemoryExceeded(long allocation, long limit, long current, String settingName) {
        return MemoryLimitExceededException.memoryPoolOutOfMemoryExceeded(MemoryLimitExceededException.getMessage(allocation, limit, current, settingName), settingName);
    }

    public static MemoryLimitExceededException memoryPoolOutOfMemoryExceeded(String message, String settingName) {
        ErrorGqlStatusObject gqlStatusObject = MemoryLimitExceededException.getPoolOutOfMemoryGqlStatus(settingName);
        return new MemoryLimitExceededException(gqlStatusObject, Status.General.MemoryPoolOutOfMemoryError, settingName, message);
    }

    public static MemoryLimitExceededException transactionMemoryLimitExceeded(long allocation, long limit, long current, String settingName) {
        return MemoryLimitExceededException.transactionMemoryLimitExceeded(MemoryLimitExceededException.getMessage(allocation, limit, current, settingName), settingName);
    }

    public static MemoryLimitExceededException transactionMemoryLimitExceeded(String message, String settingName) {
        ErrorGqlStatusObject gqlStatusObject = MemoryLimitExceededException.getTransactionMemoryLimitExceededGqlStatus(settingName);
        return new MemoryLimitExceededException(gqlStatusObject, Status.General.TransactionOutOfMemoryError, settingName, message);
    }

    public static ErrorGqlStatusObject getTransactionMemoryLimitExceededGqlStatus(String settingName) {
        return ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N73).withParam(GqlParams.StringParam.cfgSetting, settingName).build();
    }

    public static ErrorGqlStatusObject getPoolOutOfMemoryGqlStatus(String settingName) {
        return ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N72).withParam(GqlParams.StringParam.cfgSetting, settingName).build();
    }

    @Override
    public Status status() {
        return this.status;
    }

    private static String getMessage(long allocation, long limit, long current, String settingName) {
        if (StringUtils.isEmpty((CharSequence)settingName)) {
            return String.format("The allocation of an extra %s would use more than the limit %s. Currently using %s.", MemoryLimitExceededException.humanReadableByteCountBin(allocation), MemoryLimitExceededException.humanReadableByteCountBin(limit), MemoryLimitExceededException.humanReadableByteCountBin(current));
        }
        return String.format("The allocation of an extra %s would use more than the limit %s. Currently using %s. %s threshold reached", MemoryLimitExceededException.humanReadableByteCountBin(allocation), MemoryLimitExceededException.humanReadableByteCountBin(limit), MemoryLimitExceededException.humanReadableByteCountBin(current), settingName);
    }

    private static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    public String getSettingName() {
        return this.settingName;
    }
}

