/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.helpers.progress.Aggregator;
import org.neo4j.internal.helpers.progress.Indicator;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

public interface ProgressListener
extends AutoCloseable {
    public static final ProgressListener NONE = new Adapter();

    public void add(long var1);

    public void mark(char var1);

    @Override
    public void close();

    public void failed(Throwable var1);

    default public ProgressListener threadLocalReporter(int threshold) {
        return new ThreadLocalReporter(threshold, this);
    }

    default public ProgressListener threadLocalReporter() {
        return this.threadLocalReporter(1000);
    }

    public int reportResolution();

    public static class ThreadLocalReporter
    implements ProgressListener {
        private final int threshold;
        private final ProgressListener parent;
        private int localUnreportedProgress;
        private Character mark;

        ThreadLocalReporter(int threshold, ProgressListener parent) {
            this.threshold = threshold;
            this.parent = parent;
        }

        @Override
        public void add(long progress) {
            this.localUnreportedProgress = (int)((long)this.localUnreportedProgress + progress);
            if (this.localUnreportedProgress >= this.threshold) {
                this.reportToParent();
            }
        }

        @Override
        public void mark(char mark) {
            this.mark = Character.valueOf(mark);
        }

        @Override
        public void close() {
            this.reportToParent();
        }

        private void reportToParent() {
            if (this.mark != null) {
                this.parent.mark(this.mark.charValue());
                this.mark = null;
            }
            this.parent.add(this.localUnreportedProgress);
            this.localUnreportedProgress = 0;
        }

        @Override
        public void failed(Throwable e) {
            this.parent.failed(e);
        }

        @Override
        public int reportResolution() {
            return this.parent.reportResolution();
        }
    }

    public static class Adapter
    implements ProgressListener {
        @Override
        public void add(long progress) {
        }

        @Override
        public void mark(char mark) {
        }

        @Override
        public void close() {
        }

        @Override
        public void failed(Throwable e) {
        }

        @Override
        public int reportResolution() {
            return 0;
        }
    }

    public static final class MultiPartProgressListener
    extends AggregatorProgressListener {
        public final String part;
        public final long totalCount;
        private final AtomicLong progress = new AtomicLong();

        MultiPartProgressListener(Aggregator aggregator, String part, long totalCount) {
            super(aggregator);
            this.part = part;
            this.totalCount = totalCount;
            aggregator.start(this);
        }

        @Override
        public void add(long delta) {
            long current = this.progress.get();
            if (current + delta > this.totalCount) {
                delta = this.totalCount - current;
            }
            if (delta > 0L) {
                this.progress.addAndGet(delta);
                this.aggregator.update(delta);
            }
        }

        @Override
        public synchronized void close() {
            long delta = this.totalCount - this.progress.get();
            if (delta > 0L) {
                this.add(delta);
            }
            this.aggregator.complete(this);
        }
    }

    public static class SinglePartProgressListener
    extends AggregatorProgressListener {
        SinglePartProgressListener(Indicator indicator, long totalCount, ProgressMonitorFactory.IndicatorListener listener) {
            super(new Aggregator(indicator, listener));
            this.aggregator.add(new Adapter(this){}, totalCount);
            this.aggregator.initialize();
        }

        @Override
        public void add(long progress) {
            this.aggregator.update(progress);
        }

        @Override
        public void close() {
            this.aggregator.updateRemaining();
            this.aggregator.done();
        }
    }

    public static abstract class AggregatorProgressListener
    implements ProgressListener {
        protected final Aggregator aggregator;

        AggregatorProgressListener(Aggregator aggregator) {
            this.aggregator = aggregator;
        }

        @Override
        public void mark(char mark) {
            this.aggregator.mark(mark);
        }

        @Override
        public void failed(Throwable e) {
            this.aggregator.signalFailure(e);
        }

        @Override
        public int reportResolution() {
            return this.aggregator.reportResolution();
        }
    }
}

