/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.regex.Pattern;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.util.UnicodeHelper;

public final class Stringifier {
    private static final Pattern UNICODE_ESCAPE_PATTERN = Pattern.compile("([^\\\\])(\\\\u[0-9]{4})");

    public static String backtick(String txt) {
        return Stringifier.backtick(txt, false, false);
    }

    public static String backtick(String txt, boolean alwaysBacktick) {
        return Stringifier.backtick(txt, alwaysBacktick, false);
    }

    public static String backtick(String txt, boolean alwaysBacktick, boolean globbing) {
        boolean isJavaIdentifier;
        if (alwaysBacktick) {
            return "`" + Stringifier.escaped(txt) + "`";
        }
        boolean bl = isJavaIdentifier = Strings.codePoints(txt).limit(1L).allMatch(p -> UnicodeHelper.isIdentifierStart(p, CypherVersion.Cypher25) || Stringifier.orGlobbedCharacter(globbing, p)) && Strings.codePoints(txt).skip(1L).allMatch(p -> UnicodeHelper.isIdentifierPart(p, CypherVersion.Cypher25) || Stringifier.orGlobbedCharacter(globbing, p));
        if (!isJavaIdentifier) {
            return "`" + Stringifier.escaped(txt) + "`";
        }
        return txt;
    }

    private static String escaped(String txt) {
        String bt = txt.replace("`", "``");
        return UNICODE_ESCAPE_PATTERN.matcher(bt).replaceAll("$1\\\\$2");
    }

    private static boolean orGlobbedCharacter(boolean globbing, int p) {
        return globbing && (p == 42 || p == 63);
    }
}

