/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayUtil {
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public static <T> int missing(T[] array, T[] contains) {
        int missing = 0;
        for (T check : contains) {
            if (ArrayUtil.contains(array, check)) continue;
            ++missing;
        }
        return missing;
    }

    public static <T> boolean containsAll(T[] array, T[] contains) {
        for (T check : contains) {
            if (ArrayUtil.contains(array, check)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean contains(T[] array, T contains) {
        return ArrayUtil.contains(array, array.length, contains);
    }

    public static <T> boolean contains(T[] array, int arrayLength, T contains) {
        for (int i = 0; i < arrayLength; ++i) {
            T item = array[i];
            if (!ArrayUtil.nullSafeEquals(item, contains)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean nullSafeEquals(T first, T other) {
        return first == null ? first == other : first.equals(other);
    }

    public static <T> T[] union(T[] first, T[] other) {
        if (first == null || other == null) {
            return first == null ? other : first;
        }
        int missing = ArrayUtil.missing(first, other);
        if (missing == 0) {
            return first;
        }
        T[] union = Arrays.copyOf(first, first.length + missing);
        int cursor = first.length;
        for (T candidate : other) {
            if (ArrayUtil.contains(first, candidate)) continue;
            union[cursor++] = candidate;
            --missing;
        }
        assert (missing == 0);
        return union;
    }

    @SafeVarargs
    public static <T> T[] concat(T first, T ... additional) {
        Object[] result = (Object[])Array.newInstance(additional.getClass().getComponentType(), additional.length + 1);
        result[0] = first;
        System.arraycopy(additional, 0, result, 1, additional.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] concat(T[] initial, T ... additional) {
        Object[] result = (Object[])Array.newInstance(additional.getClass().getComponentType(), initial.length + additional.length);
        System.arraycopy(initial, 0, result, 0, initial.length);
        System.arraycopy(additional, 0, result, initial.length, additional.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] concatArrays(T[] initial, T[] ... additional) {
        int length = initial.length;
        for (T[] array : additional) {
            length += array.length;
        }
        T[] result = Arrays.copyOf(initial, length);
        int offset = initial.length;
        for (T[] array : additional) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] array(T ... varargs) {
        return varargs;
    }

    public static <T> T lastOf(T[] array) {
        return array[array.length - 1];
    }

    public static <T> int indexOf(T[] array, T item) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    @SafeVarargs
    public static <T> T[] without(T[] source, T ... toRemove) {
        T[] result = Arrays.copyOf(source, source.length);
        int length = result.length;
        for (T candidate : toRemove) {
            int index = ArrayUtil.indexOf(result, candidate);
            if (index == -1) continue;
            if (index + 1 < length) {
                result[index] = result[length - 1];
            }
            --length;
        }
        return length == result.length ? result : Arrays.copyOf(result, length);
    }

    public static <T> void reverse(T[] array) {
        int low = 0;
        int high = array.length - 1;
        while (high - low > 0) {
            T lowItem = array[low];
            array[low] = array[high];
            array[high] = lowItem;
            ++low;
            --high;
        }
    }

    public static <T> T single(T[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("Expected an array with one element, but the array was empty: " + array.getClass().getSimpleName());
        }
        if (array.length > 1) {
            throw new IllegalArgumentException("Expected an array with one element, but the array had " + array.length + " elements: " + Arrays.toString(array));
        }
        return array[0];
    }

    public static byte[] filled(int size, byte value) {
        byte[] arr = new byte[size];
        if (value != 0) {
            Arrays.fill(arr, value);
        }
        return arr;
    }

    public static short[] filled(int size, short value) {
        short[] arr = new short[size];
        if (value != 0) {
            Arrays.fill(arr, value);
        }
        return arr;
    }

    public static int[] filled(int size, int value) {
        int[] arr = new int[size];
        if (value != 0) {
            Arrays.fill(arr, value);
        }
        return arr;
    }

    public static long[] filled(int size, long value) {
        long[] arr = new long[size];
        if (value != 0L) {
            Arrays.fill(arr, value);
        }
        return arr;
    }

    public static float[] filled(int size, float value) {
        float[] arr = new float[size];
        if (value != 0.0f) {
            Arrays.fill(arr, value);
        }
        return arr;
    }

    public static double[] filled(int size, double value) {
        double[] arr = new double[size];
        if (value != 0.0) {
            Arrays.fill(arr, value);
        }
        return arr;
    }

    private ArrayUtil() {
    }
}

