/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.HighWaterMarkMemoryPool;
import org.neo4j.memory.LimitedMemoryTracker;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class ExecutionContextMemoryTracker
implements LimitedMemoryTracker {
    public static final long NO_LIMIT = 0L;
    private static final long INFINITY = Long.MAX_VALUE;
    private static final long DEFAULT_GRAB_SIZE = 8192L;
    private static final int CLIENT_CALLS_PER_POOL_INTERACTION_THRESHOLD = 10;
    private final HighWaterMarkMemoryPool memoryPool;
    private long grabSize;
    private final long maxGrabSize;
    private int clientCallsSinceLastPoolInteraction;
    private final String limitSettingName;
    private final BooleanSupplier openCheck;
    private long localBytesLimit;
    private long localHeapPool;
    private long allocatedBytesHeap;
    private long allocatedBytesNative;

    public ExecutionContextMemoryTracker() {
        this(HighWaterMarkMemoryPool.NO_TRACKING);
    }

    public ExecutionContextMemoryTracker(HighWaterMarkMemoryPool memoryPool) {
        this(memoryPool, Long.MAX_VALUE, 8192L, 8192L, null);
    }

    public ExecutionContextMemoryTracker(HighWaterMarkMemoryPool memoryPool, long localBytesLimit, long grabSize, long maxGrabSize, String limitSettingName) {
        this(memoryPool, localBytesLimit, grabSize, maxGrabSize, limitSettingName, () -> true);
    }

    public ExecutionContextMemoryTracker(HighWaterMarkMemoryPool memoryPool, long localBytesLimit, long grabSize, long maxGrabSize, String limitSettingName, BooleanSupplier openCheck) {
        this.memoryPool = Objects.requireNonNull(memoryPool);
        this.localBytesLimit = ExecutionContextMemoryTracker.validateLimit(localBytesLimit);
        this.grabSize = Preconditions.requireNonNegative(grabSize);
        this.maxGrabSize = Preconditions.requireNonNegative(maxGrabSize);
        this.limitSettingName = limitSettingName;
        this.openCheck = openCheck;
        this.clientCallsSinceLastPoolInteraction = 10;
    }

    @Override
    public void allocateNative(long bytes) {
        assert (this.openCheck.getAsBoolean()) : "Tracker should be open to allow new allocations.";
        if (bytes == 0L) {
            return;
        }
        Preconditions.requirePositive(bytes);
        this.allocatedBytesNative += bytes;
        if (this.allocatedBytesHeap + this.allocatedBytesNative > this.localBytesLimit) {
            this.allocatedBytesNative -= bytes;
            throw MemoryLimitExceededException.transactionMemoryLimitExceeded(bytes, this.localBytesLimit, this.allocatedBytesHeap + this.allocatedBytesNative, this.limitSettingName);
        }
        try {
            this.memoryPool.reserveNative(bytes);
        }
        catch (MemoryLimitExceededException t) {
            this.allocatedBytesNative -= bytes;
            throw t;
        }
    }

    @Override
    public void releaseNative(long bytes) {
        if (bytes == 0L) {
            return;
        }
        assert (this.openCheck.getAsBoolean()) : "Tracker should be open to allow releasing native memory.";
        this.allocatedBytesNative -= bytes;
        this.memoryPool.releaseNative(bytes);
    }

    @Override
    public void allocateHeap(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.requirePositive(bytes);
        this.allocatedBytesHeap += bytes;
        ++this.clientCallsSinceLastPoolInteraction;
        if (this.allocatedBytesHeap + this.allocatedBytesNative > this.localBytesLimit) {
            this.allocatedBytesHeap -= bytes;
            throw MemoryLimitExceededException.transactionMemoryLimitExceeded(bytes, this.localBytesLimit, this.allocatedBytesHeap + this.allocatedBytesNative, this.limitSettingName);
        }
        this.localHeapPool -= bytes;
        if (this.localHeapPool < 0L) {
            long grab = Math.max(bytes, this.grabSize);
            try {
                this.reserveHeapFromPool(grab);
            }
            catch (MemoryLimitExceededException t) {
                this.allocatedBytesHeap -= bytes;
                throw t;
            }
        }
    }

    @Override
    public void releaseHeap(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.requireNonNegative(bytes);
        this.allocatedBytesHeap -= bytes;
        this.localHeapPool += bytes;
        ++this.clientCallsSinceLastPoolInteraction;
        if (this.localHeapPool > this.grabSize << 1) {
            long memoryToRelease = Math.max(this.grabSize, this.localHeapPool - (this.grabSize << 1));
            this.releaseHeapToPool(memoryToRelease);
        }
    }

    @Override
    public long heapHighWaterMark() {
        return this.memoryPool.heapHighWaterMark();
    }

    @Override
    public long usedNativeMemory() {
        return this.allocatedBytesNative;
    }

    @Override
    public long estimatedHeapMemory() {
        return this.allocatedBytesHeap;
    }

    @Override
    public void reset() {
        long localHeapToRelease;
        if (this.openCheck.getAsBoolean() && (localHeapToRelease = this.localHeapPool) > 0L) {
            this.memoryPool.releaseHeap(localHeapToRelease);
        }
        this.localHeapPool = 0L;
        this.allocatedBytesHeap = 0L;
        this.allocatedBytesNative = 0L;
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        return new DefaultScopedMemoryTracker(this);
    }

    @Override
    public void setLimit(long localBytesLimit) {
        this.localBytesLimit = ExecutionContextMemoryTracker.validateLimit(localBytesLimit);
    }

    @VisibleForTesting
    public long localHeapPool() {
        return this.localHeapPool;
    }

    private void reserveHeapFromPool(long size) {
        if (this.openCheck.getAsBoolean()) {
            if (this.clientCallsSinceLastPoolInteraction < 10) {
                this.increaseGrabSize(size);
            }
            this.memoryPool.reserveHeap(size);
            this.localHeapPool += size;
            this.clientCallsSinceLastPoolInteraction = 0;
        }
    }

    private void releaseHeapToPool(long size) {
        if (this.openCheck.getAsBoolean()) {
            if (this.clientCallsSinceLastPoolInteraction < 10) {
                this.increaseGrabSize(size);
            }
            this.memoryPool.releaseHeap(size);
            this.localHeapPool -= size;
            this.clientCallsSinceLastPoolInteraction = 0;
        }
    }

    private void increaseGrabSize(long size) {
        long newGrabSize;
        this.grabSize = newGrabSize = Math.min(Numbers.ceilingPowerOfTwo(size + 1L), this.maxGrabSize);
    }

    private static long validateLimit(long localBytesLimit) {
        return localBytesLimit == 0L ? Long.MAX_VALUE : Preconditions.requireNonNegative(localBytesLimit);
    }
}

