/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.hashing;

import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.neo4j.internal.helpers.VarHandleUtils;

public final class RapidHash {
    private static final VarHandle LE_INTEGER = VarHandleUtils.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle LE_LONG = VarHandleUtils.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final long RAPID_SEED = -4766890152743124951L;
    private static final long SECRET0 = 3257665815644502181L;
    private static final long SECRET1 = -8378864009470890807L;
    private static final long SECRET2 = 5418857496715711651L;

    private RapidHash() {
    }

    public static long hash(String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return RapidHash.hash(bytes, bytes.length);
    }

    public static long hash(byte[] key, int len) {
        return RapidHash.hashInternal(key, len);
    }

    private static long hashInternal(byte[] key, int len) {
        long b;
        long a;
        long seed = 0xBDD89AA982704029L ^ RapidHash.mix(-8003715239535429492L, -8378864009470890807L) ^ (long)len;
        if (len <= 16) {
            if (len >= 4) {
                int pLast = len - 4;
                a = RapidHash.u32(key, 0) << 32 | RapidHash.u32(key, pLast);
                int delta = (len & 0x18) >> (len >> 3);
                b = RapidHash.u32(key, delta) << 32 | RapidHash.u32(key, pLast - delta);
            } else if (len > 0) {
                a = RapidHash.readSmall(key, len);
                b = 0L;
            } else {
                b = 0L;
                a = 0L;
            }
        } else {
            int i;
            int p = 0;
            if (i > 48) {
                long see1 = seed;
                long see2 = seed;
                for (i = len; i >= 96; i -= 96) {
                    seed = RapidHash.mix(RapidHash.i64(key, p) ^ 0x2D358DCCAA6C78A5L, RapidHash.i64(key, p + 8) ^ seed);
                    see1 = RapidHash.mix(RapidHash.i64(key, p + 16) ^ 0x8BB84B93962EACC9L, RapidHash.i64(key, p + 24) ^ see1);
                    see2 = RapidHash.mix(RapidHash.i64(key, p + 32) ^ 0x4B33A62ED433D4A3L, RapidHash.i64(key, p + 40) ^ see2);
                    seed = RapidHash.mix(RapidHash.i64(key, p + 48) ^ 0x2D358DCCAA6C78A5L, RapidHash.i64(key, p + 56) ^ seed);
                    see1 = RapidHash.mix(RapidHash.i64(key, p + 64) ^ 0x8BB84B93962EACC9L, RapidHash.i64(key, p + 72) ^ see1);
                    see2 = RapidHash.mix(RapidHash.i64(key, p + 80) ^ 0x4B33A62ED433D4A3L, RapidHash.i64(key, p + 88) ^ see2);
                    p += 96;
                }
                if (i >= 48) {
                    seed = RapidHash.mix(RapidHash.i64(key, p) ^ 0x2D358DCCAA6C78A5L, RapidHash.i64(key, p + 8) ^ seed);
                    see1 = RapidHash.mix(RapidHash.i64(key, p + 16) ^ 0x8BB84B93962EACC9L, RapidHash.i64(key, p + 24) ^ see1);
                    see2 = RapidHash.mix(RapidHash.i64(key, p + 32) ^ 0x4B33A62ED433D4A3L, RapidHash.i64(key, p + 40) ^ see2);
                    p += 48;
                    i -= 48;
                }
                seed ^= see1 ^ see2;
            }
            if (i > 16) {
                seed = RapidHash.mix(RapidHash.i64(key, p) ^ 0x4B33A62ED433D4A3L, RapidHash.i64(key, p + 8) ^ seed ^ 0x8BB84B93962EACC9L);
                if (i > 32) {
                    seed = RapidHash.mix(RapidHash.i64(key, p + 16) ^ 0x4B33A62ED433D4A3L, RapidHash.i64(key, p + 24) ^ seed);
                }
            }
            a = RapidHash.i64(key, p + i - 16);
            b = RapidHash.i64(key, p + i - 8);
        }
        long high = Math.unsignedMultiplyHigh(a ^= 0x8BB84B93962EACC9L, b ^= seed);
        return RapidHash.mix(a * b ^ 0x2D358DCCAA6C78A5L ^ (long)len, high ^ 0x8BB84B93962EACC9L);
    }

    private static long mix(long A, long B) {
        return A * B ^ Math.unsignedMultiplyHigh(A, B);
    }

    private static long i64(byte[] key, int p) {
        return LE_LONG.get(key, p);
    }

    private static long u32(byte[] key, int p) {
        return Integer.toUnsignedLong(LE_INTEGER.get(key, p));
    }

    private static long readSmall(byte[] p, int k) {
        return Byte.toUnsignedLong(p[0]) << 56 | Byte.toUnsignedLong(p[k >>> 1]) << 32 | Byte.toUnsignedLong(p[k - 1]);
    }
}

