/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.kernel.diagnostics.providers.SystemDiagnostics;
import org.neo4j.kernel.internal.Version;
import picocli.CommandLine;

@CommandLine.Command(headerHeading="%n", synopsisHeading="%n@|bold,underline USAGE|@%n%n", descriptionHeading="%n@|bold,underline DESCRIPTION|@%n%n", optionListHeading="%n@|bold,underline OPTIONS|@%n%n", parameterListHeading="%n@|bold,underline PARAMETERS|@%n%n", exitCodeOnSuccess=0, exitCodeOnUsageHelp=0, exitCodeOnInvalidInput=64, exitCodeOnExecutionException=70, showDefaultValues=true)
public abstract class AbstractCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--verbose"}, description={"Enable verbose output."})
    protected boolean verbose;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, fallbackValue="true", description={"Show this help message and exit."})
    private boolean helpRequested;
    @CommandLine.Option(names={"--expand-commands"}, fallbackValue="true", description={"Allow command expansion in config value evaluation."})
    protected boolean allowCommandExpansion;
    protected final ExecutionContext ctx;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    protected AbstractCommand(ExecutionContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    protected abstract void execute() throws Exception;

    protected List<Path> configFiles() {
        ArrayList<Path> config = new ArrayList<Path>();
        Path defaultConf = this.ctx.confDir().resolve("neo4j.conf");
        if (this.ctx.fs().fileExists(defaultConf)) {
            config.add(defaultConf);
        }
        return config;
    }

    @Override
    public Integer call() throws Exception {
        if (this.verbose) {
            this.printVerboseHeader();
            this.printConfigInformation();
        }
        try {
            this.execute();
        }
        catch (CommandFailedException e) {
            if (this.verbose) {
                e.printStackTrace(this.ctx.err());
            } else {
                this.ctx.err().println(e.getMessage());
                this.ctx.err().println("Run with '--verbose' for a more detailed error message.");
            }
            return e.getExitCode();
        }
        return 0;
    }

    private void printVerboseHeader() {
        PrintStream out = this.ctx.out();
        out.println("neo4j " + Version.getNeo4jVersion());
        SystemDiagnostics.JAVA_VIRTUAL_MACHINE.dump(out::println);
    }

    private void printConfigInformation() {
        PrintStream out = this.ctx.out();
        out.println("Configuration files used (ordered by priority):");
        this.configFiles().forEach(file -> out.println(file.toAbsolutePath()));
        out.println("--------------------");
    }
}

