/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.PrintStream;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.kernel.diagnostics.providers.SystemDiagnostics;
import org.neo4j.kernel.internal.Version;
import picocli.CommandLine;

@CommandLine.Command(headerHeading="%n", synopsisHeading="%n@|bold,underline USAGE|@%n%n", descriptionHeading="%n@|bold,underline DESCRIPTION|@%n%n", optionListHeading="%n@|bold,underline OPTIONS|@%n%n", parameterListHeading="%n@|bold,underline PARAMETERS|@%n%n", exitCodeOnSuccess=0, exitCodeOnUsageHelp=0, exitCodeOnInvalidInput=64, exitCodeOnExecutionException=70, showDefaultValues=true)
public abstract class AbstractCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--verbose"}, description={"Enable verbose output."})
    protected boolean verbose;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, fallbackValue="true", description={"Show this help message and exit."})
    private boolean helpRequested;
    @CommandLine.Option(names={"--expand-commands"}, fallbackValue="true", description={"Allow command expansion in config value evaluation."})
    protected boolean allowCommandExpansion;
    protected final ExecutionContext ctx;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    protected AbstractCommand(ExecutionContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    protected abstract void execute() throws Exception;

    @Override
    public Integer call() throws Exception {
        if (this.verbose) {
            this.printVerboseHeader();
        }
        try {
            this.execute();
        }
        catch (CommandFailedException e) {
            if (this.verbose) {
                e.printStackTrace(this.ctx.err());
            } else {
                this.ctx.err().println(e.getMessage());
                this.ctx.err().println("Run with '--verbose' for a more detailed error message.");
            }
            return e.getExitCode();
        }
        return 0;
    }

    private void printVerboseHeader() {
        PrintStream out = this.ctx.out();
        out.println("neo4j " + Version.getNeo4jVersion());
        SystemDiagnostics.JAVA_VIRTUAL_MACHINE.dump(out::println);
    }
}

