/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import org.neo4j.configuration.helpers.DatabaseNamePattern;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.configuration.helpers.FromPaths;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import picocli.CommandLine;

public interface Converters {

    public static class DatabaseNamePatternConverter
    implements CommandLine.ITypeConverter<DatabaseNamePattern> {
        public DatabaseNamePattern convert(String name) {
            try {
                return new DatabaseNamePattern(name);
            }
            catch (Exception ex) {
                throw new CommandLine.TypeConversionException(String.format("Invalid database name '%s'. (%s)", name, ex));
            }
        }
    }

    public static class FromPathsConverter
    implements CommandLine.ITypeConverter<FromPaths> {
        public FromPaths convert(String value) throws Exception {
            try {
                return new FromPaths(value);
            }
            catch (Exception ex) {
                throw new CommandLine.TypeConversionException(String.format("Invalid from parameter '%s'. (%s)", value, ex));
            }
        }
    }

    public static class DatabaseNameConverter
    implements CommandLine.ITypeConverter<NormalizedDatabaseName> {
        public NormalizedDatabaseName convert(String name) {
            try {
                NormalizedDatabaseName databaseName = new NormalizedDatabaseName(name);
                DatabaseNameValidator.validateInternalDatabaseName((NormalizedDatabaseName)databaseName);
                return databaseName;
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(String.format("Invalid database name '%s'. (%s)", name, e));
            }
        }
    }

    public static class ByteUnitConverter
    implements CommandLine.ITypeConverter<Long> {
        public Long convert(String value) {
            try {
                return ByteUnit.parse((String)value);
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(String.format("cannot convert '%s' to byte units (%s)", value, e));
            }
        }
    }
}

