/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.ZoneId;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;

public final class Util {
    private Util() {
    }

    public static boolean isSameOrChildFile(File parent, File candidate) {
        Path canonicalCandidate = FileUtils.getCanonicalFile((File)candidate).toPath();
        Path canonicalParentPath = FileUtils.getCanonicalFile((File)parent).toPath();
        return canonicalCandidate.startsWith(canonicalParentPath);
    }

    public static boolean isSameOrChildPath(Path parent, Path candidate) {
        Path normalizedCandidate = candidate.normalize();
        Path normalizedParent = parent.normalize();
        return normalizedCandidate.startsWith(normalizedParent);
    }

    public static void wrapIOException(IOException e) throws CommandFailedException {
        throw new CommandFailedException(String.format("Unable to load database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), e);
    }

    public static LogProvider configuredLogProvider(Config config, OutputStream out) {
        return FormattedLogProvider.withZoneId((ZoneId)((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId()).withDefaultLogLevel((Level)config.get(GraphDatabaseSettings.store_internal_log_level)).toOutputStream(out);
    }
}

