/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.arguments;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.text.WordUtils;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.arguments.MandatoryPositionalArgument;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalBooleanArg;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.commandline.arguments.OptionalPositionalArgument;
import org.neo4j.commandline.arguments.PositionalArgument;
import org.neo4j.commandline.arguments.common.Database;
import org.neo4j.commandline.arguments.common.MandatoryCanonicalPath;
import org.neo4j.commandline.arguments.common.OptionalCanonicalPath;
import org.neo4j.helpers.Args;

public class Arguments {
    public static final Arguments NO_ARGS = new Arguments();
    private static final int LINE_LENGTH = 80;
    private static final int MIN_RIGHT_COL_WIDTH = 30;
    private static final String NEWLINE = System.getProperty("line.separator");
    private final Map<String, NamedArgument> namedArgs = new LinkedHashMap<String, NamedArgument>();
    private final ArrayList<PositionalArgument> positionalArgs = new ArrayList();
    private Args parsedArgs;

    public Arguments withDatabase() {
        return this.withArgument(new Database());
    }

    public Arguments withAdditionalConfig() {
        return this.withArgument(new OptionalCanonicalPath("additional-config", "config-file-path", "", "Configuration file to supply additional configuration in."));
    }

    public Arguments withTo(String description) {
        return this.withArgument(new MandatoryCanonicalPath("to", "destination-path", description));
    }

    public Arguments withOptionalPositionalArgument(int position, String value) {
        return this.withPositionalArgument(new OptionalPositionalArgument(position, value));
    }

    public Arguments withMandatoryPositionalArgument(int position, String value) {
        return this.withPositionalArgument(new MandatoryPositionalArgument(position, value));
    }

    public Arguments withArgument(NamedArgument namedArgument) {
        this.namedArgs.put(namedArgument.name(), namedArgument);
        return this;
    }

    public Arguments withPositionalArgument(PositionalArgument arg) {
        this.positionalArgs.add(arg);
        return this;
    }

    public String usage() {
        StringBuilder sb = new StringBuilder();
        if (!this.namedArgs.isEmpty()) {
            sb.append(this.namedArgs.values().stream().map(NamedArgument::usage).collect(Collectors.joining(" ")));
        }
        if (!this.positionalArgs.isEmpty()) {
            sb.append(" ");
            this.positionalArgs.sort(Comparator.comparingInt(PositionalArgument::position));
            sb.append(this.positionalArgs.stream().map(PositionalArgument::usage).collect(Collectors.joining(" ")));
        }
        return sb.toString().trim();
    }

    public String description(String text) {
        String wrappedText = Arguments.wrapText(text, 80);
        if (this.namedArgs.isEmpty()) {
            return wrappedText;
        }
        wrappedText = String.join((CharSequence)(NEWLINE + NEWLINE), wrappedText, "options:");
        int alignLength = this.namedArgs.values().stream().map(a -> a.optionsListing().length()).reduce(0, Integer::max);
        return String.join((CharSequence)NEWLINE, wrappedText, this.namedArgs.values().stream().map(c -> this.formatArgumentDescription(alignLength, (NamedArgument)c)).collect(Collectors.joining(NEWLINE)));
    }

    public static String wrapText(String text, int lineLength) {
        List<String> lines = Arrays.asList(text.split("\r?\n"));
        return lines.stream().map(l -> l.length() > lineLength ? WordUtils.wrap((String)l, (int)lineLength) : l).collect(Collectors.joining(NEWLINE));
    }

    public String formatArgumentDescription(int longestAlignmentLength, NamedArgument argument) {
        String left = String.format("  %s", argument.optionsListing());
        String right = argument instanceof OptionalNamedArg ? String.format("%s [default:%s]", argument.description(), ((OptionalNamedArg)argument).defaultValue()) : argument.description();
        return Arguments.rightColumnFormatted(left, right, longestAlignmentLength + 5);
    }

    public static String rightColumnFormatted(String leftText, String rightText, int rightAlignIndex) {
        int newLineIndent = 6;
        int rightWidth = 80 - rightAlignIndex;
        boolean startOnNewLine = false;
        if (rightWidth < 30) {
            startOnNewLine = true;
            rightWidth = 74;
        }
        String[] rightLines = Arguments.wrapText(rightText, rightWidth).split(NEWLINE);
        String fmt = "%-" + (startOnNewLine ? 6 : rightAlignIndex) + "s%s";
        String firstLine = String.format(fmt, leftText, startOnNewLine ? "" : rightLines[0]);
        String rest = Arrays.stream(rightLines).skip(startOnNewLine ? 0L : 1L).map(l -> String.format(fmt, "", l)).collect(Collectors.joining(NEWLINE));
        if (rest.isEmpty()) {
            return firstLine;
        }
        return String.join((CharSequence)NEWLINE, firstLine, rest);
    }

    public Arguments parse(String[] args) throws IncorrectUsage {
        List<String> flags = this.namedArgs.entrySet().stream().filter(e -> e.getValue() instanceof OptionalBooleanArg).map(Map.Entry::getKey).collect(Collectors.toList());
        this.parsedArgs = Args.withFlags((String[])flags.toArray(new String[flags.size()])).parse(args);
        this.validate();
        return this;
    }

    public String get(int pos) {
        if (pos >= 0 && pos < this.positionalArgs.size()) {
            return this.positionalArgs.get(pos).parse(this.parsedArgs);
        }
        throw new IllegalArgumentException(String.format("Positional argument '%d' not specified.", pos));
    }

    public String get(String argName) {
        if (this.namedArgs.containsKey(argName)) {
            return this.namedArgs.get(argName).parse(this.parsedArgs);
        }
        throw new IllegalArgumentException("No such argument available to be parsed: " + argName);
    }

    private void validate() throws IncorrectUsage {
        for (String o2 : this.parsedArgs.asMap().keySet()) {
            if (this.namedArgs.containsKey(o2)) continue;
            throw new IncorrectUsage(String.format("unrecognized option: '%s'", o2));
        }
        long mandatoryPositionalArgs = this.positionalArgs.stream().filter(o -> o instanceof MandatoryPositionalArgument).count();
        if ((long)this.parsedArgs.orphans().size() < mandatoryPositionalArgs) {
            throw new IncorrectUsage("not enough arguments");
        }
        String excessArgs = this.parsedArgs.orphans().stream().skip(this.positionalArgs.size()).collect(Collectors.joining(" "));
        if (!excessArgs.isEmpty()) {
            throw new IncorrectUsage(String.format("unrecognized arguments: '%s'", excessArgs));
        }
    }

    public boolean getBoolean(String argName) {
        return this.get(argName, Boolean::parseBoolean);
    }

    public Optional<Path> getOptionalPath(String argName) {
        String p = this.get(argName);
        if (p.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Paths.get(p, new String[0]));
    }

    public Path getMandatoryPath(String argName) {
        Optional<Path> p = this.getOptionalPath(argName);
        if (p.isPresent()) {
            return p.get();
        }
        throw new IllegalArgumentException(String.format("Missing exampleValue for '%s'", argName));
    }

    public <T> T get(String argName, Function<String, T> converter) {
        return converter.apply(this.get(argName));
    }

    public boolean has(String argName) {
        if (this.namedArgs.containsKey(argName)) {
            return this.namedArgs.get(argName).has(this.parsedArgs);
        }
        throw new IllegalArgumentException("No such argument available: " + argName);
    }
}

