/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.arguments.Arguments;

public class Usage {
    private final String scriptName;
    private final CommandLocator commands;

    public Usage(String scriptName, CommandLocator commands) {
        this.scriptName = scriptName;
        this.commands = commands;
    }

    public void print(Consumer<String> output) {
        output.accept(String.format("usage: %s <command>", this.scriptName));
        output.accept("");
        output.accept("Manage your Neo4j instance.");
        output.accept("");
        output.accept("environment variables:");
        output.accept("    NEO4J_DEBUG   Set to anything to enable debug output.");
        output.accept("    NEO4J_HOME    Neo4j home directory.");
        output.accept("    NEO4J_CONF    Path to directory which contains neo4j.conf.");
        output.accept("    HEAP_SIZE     Set size of JVM heap during command execution.");
        output.accept("                  Takes a number and a unit, for example 512m.");
        output.accept("");
        output.accept("available commands:");
        this.printCommandsUnderASegment(output);
        output.accept("");
        output.accept(String.format("Use %s help <command> for more details.", this.scriptName));
    }

    private void printCommandsUnderASegment(Consumer<String> output) {
        ArrayList<AdminCommand.Provider> providers = new ArrayList<AdminCommand.Provider>();
        this.commands.getAllProviders().forEach(providers::add);
        providers.sort(Comparator.comparing(AdminCommand.Provider::name));
        providers.forEach(command -> {
            CommandUsage commandUsage = new CommandUsage((AdminCommand.Provider)((Object)command), this.scriptName);
            commandUsage.printIndentedSummary(output);
        });
    }

    public void printUsageForCommand(AdminCommand.Provider command, Consumer<String> output) {
        CommandUsage commandUsage = new CommandUsage(command, this.scriptName);
        commandUsage.printDetailed(output);
    }

    public static class CommandUsage {
        private final AdminCommand.Provider command;
        private final String scriptName;

        public CommandUsage(AdminCommand.Provider command, String scriptName) {
            this.command = command;
            this.scriptName = scriptName;
        }

        public void printSummary(Consumer<String> output) {
            output.accept(String.format("%s", this.command.name()));
            output.accept("    " + this.command.summary());
        }

        public void printIndentedSummary(Consumer<String> output) {
            this.printSummary(s -> output.accept("    " + s));
        }

        public void printDetailed(Consumer<String> output) {
            for (Arguments arguments : this.command.possibleArguments()) {
                String left = String.format("usage: %s %s", this.scriptName, this.command.name());
                output.accept(Arguments.rightColumnFormatted(left, arguments.usage(), left.length() + 1));
            }
            output.accept("");
            output.accept(this.command.allArguments().description(this.command.description()));
        }
    }
}

