/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;

public class HelpCommand
implements AdminCommand {
    private final Usage usage;
    private final Consumer<String> output;

    public HelpCommand(Usage usage, Consumer<String> output) {
        this.usage = usage;
        this.output = output;
    }

    @Override
    public void execute(String ... args) {
        this.usage.print(this.output);
    }

    public static class Provider
    extends AdminCommand.Provider {
        private final Usage usage;

        public Provider(Usage usage) {
            super("help", new String[0]);
            this.usage = usage;
        }

        @Override
        public Optional<String> arguments() {
            return Optional.empty();
        }

        @Override
        public String description() {
            return "Display this help text.";
        }

        @Override
        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new HelpCommand(this.usage, outsideWorld::stdOutLine);
        }
    }
}

