/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.server.configuration.ConfigLoader;

public class ImportCommand
implements AdminCommand {
    private final Path homeDir;
    private final Path configDir;

    public ImportCommand(Path homeDir, Path configDir) {
        this.homeDir = homeDir;
        this.configDir = configDir;
    }

    @Override
    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        File from;
        String database;
        Args parsedArgs = Args.parse((String[])args);
        try {
            parsedArgs.interpretOption("mode", Converters.mandatory(), s -> s, new Validator[]{Validators.inList((String[])new String[]{"database"})});
            database = (String)parsedArgs.interpretOption("database", Converters.mandatory(), s -> s, new Validator[0]);
            from = (File)parsedArgs.interpretOption("from", Converters.mandatory(), Converters.toFile(), new Validator[]{Validators.CONTAINS_EXISTING_DATABASE});
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        try {
            Config config = ImportCommand.loadNeo4jConfig(this.homeDir, this.configDir, database);
            this.copyDatabase(from, config);
            this.removeMessagesLog(config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void copyDatabase(File from, Config config) throws IOException {
        FileUtils.copyRecursively((File)from, (File)((File)config.get(DatabaseManagementSystemSettings.database_path)));
    }

    private void removeMessagesLog(Config config) {
        FileUtils.deleteFile((File)new File((File)config.get(DatabaseManagementSystemSettings.database_path), "messages.log"));
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName) {
        ConfigLoader configLoader = new ConfigLoader(ImportCommand.settings());
        Config config = configLoader.loadConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()), new Pair[0]);
        return config.with(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.active_database.name(), databaseName}), new Class[0]);
    }

    private static List<Class<?>> settings() {
        ArrayList settings = new ArrayList();
        settings.add(GraphDatabaseSettings.class);
        settings.add(DatabaseManagementSystemSettings.class);
        return settings;
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("import", new String[0]);
        }

        @Override
        public Optional<String> arguments() {
            return Optional.of("--mode=<mode> --database=<database-name> --from=<source-directory>");
        }

        @Override
        public String description() {
            return "Import a database from a pre-3.0 Neo4j installation. <source-directory> is the database location (e.g. <neo4j-root>/data/graph.db).";
        }

        @Override
        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new ImportCommand(homeDir, configDir);
        }
    }
}

