/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.HelpCommand;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.RealOutsideWorld;
import org.neo4j.commandline.admin.Usage;

public class AdminTool {
    private final String scriptName = "neo4j-admin";
    private final CommandLocator locator;
    private final OutsideWorld outsideWorld;
    private final boolean debug;
    private final Usage usage;

    public static void main(String[] args) {
        Path homeDir = Paths.get(System.getenv("NEO4J_HOME"), new String[0]);
        Path configDir = Paths.get(System.getenv("NEO4J_CONF"), new String[0]);
        boolean debug = System.getenv("NEO4J_DEBUG") != null;
        new AdminTool(CommandLocator.fromServiceLocator(), new RealOutsideWorld(), debug).execute(homeDir, configDir, args);
    }

    public AdminTool(CommandLocator locator, OutsideWorld outsideWorld, boolean debug) {
        this.locator = CommandLocator.withAdditionalCommand(this.help(), locator);
        this.outsideWorld = outsideWorld;
        this.debug = debug;
        this.usage = new Usage("neo4j-admin", this.locator);
    }

    public void execute(Path homeDir, Path configDir, String ... args) {
        try {
            AdminCommand.Provider provider;
            if (args.length == 0) {
                this.badUsage("you must provide a command");
                return;
            }
            String name = args[0];
            String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
            try {
                provider = this.locator.findProvider(name);
            }
            catch (NoSuchElementException e) {
                this.badUsage(String.format("unrecognized command: %s", name));
                return;
            }
            AdminCommand command = provider.create(homeDir, configDir, this.outsideWorld);
            try {
                command.execute(commandArgs);
                this.success();
            }
            catch (IncorrectUsage e) {
                this.badUsage(provider, e);
            }
            catch (CommandFailed e) {
                this.commandFailed(e);
            }
        }
        catch (RuntimeException e) {
            this.unexpected(e);
        }
    }

    private Supplier<AdminCommand.Provider> help() {
        return () -> new HelpCommand.Provider(this.usage);
    }

    private void badUsage(AdminCommand.Provider command, IncorrectUsage e) {
        Usage.CommandUsage commandUsage = new Usage.CommandUsage(command, "neo4j-admin");
        commandUsage.print(this.outsideWorld::stdErrLine);
        this.failure(e.getMessage());
    }

    private void badUsage(String message) {
        this.usage.print(this.outsideWorld::stdErrLine);
        this.failure(message);
    }

    private void unexpected(RuntimeException e) {
        this.failure("unexpected error", e);
    }

    private void commandFailed(CommandFailed e) {
        this.failure("command failed", e);
    }

    private void failure(String message, Exception e) {
        if (this.debug) {
            this.failure(e, String.format("%s: %s", message, e.getMessage()));
        } else {
            this.failure(e.getMessage());
        }
    }

    private void failure(Exception e, String message) {
        this.outsideWorld.printStacktrace(e);
        this.failure(message);
    }

    private void failure(String message) {
        this.outsideWorld.stdErrLine(message);
        this.outsideWorld.exit(1);
    }

    private void success() {
        this.outsideWorld.exit(0);
    }
}

