/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.function.Supplier;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.Output;
import org.neo4j.helpers.Args;

public class Usage {
    private final String scriptName;
    private final Output out;
    private final Supplier<Iterable<AdminCommand.Provider>> commands;
    private final String extraHelp;

    public Usage(String scriptName, Output out, Supplier<Iterable<AdminCommand.Provider>> commands, String extraHelp) {
        this.scriptName = scriptName;
        this.out = out;
        this.commands = commands;
        this.extraHelp = extraHelp;
    }

    public void print() {
        this.out.line("Usage:");
        this.out.line("");
        for (AdminCommand.Provider command : this.commands.get()) {
            new CommandUsage(command, this.out, this.scriptName).print();
        }
        this.out.line(this.extraHelp);
        this.out.line("");
    }

    public static class CommandUsage {
        private final AdminCommand.Provider command;
        private final Output out;
        private final String scriptName;

        public CommandUsage(AdminCommand.Provider command, Output out, String scriptName) {
            this.command = command;
            this.out = out;
            this.scriptName = scriptName;
        }

        public void print() {
            String arguments = this.command.arguments().map(s -> " " + s).orElse("");
            this.out.line(String.format("%s %s%s", this.scriptName, this.command.name(), arguments));
            this.out.line("");
            for (String line : Args.splitLongLine((String)this.command.description(), (int)80)) {
                this.out.line("    " + line);
            }
            this.out.line("");
        }
    }
}

