/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.HelpCommand;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.Output;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;

public class AdminTool {
    private final String scriptName = "neo4j-admin";
    private final CommandLocator locator;
    private final Output out;
    private final boolean debug;
    private final Usage usage;

    public static void main(String[] args) {
        Path homeDir = Paths.get(System.getenv("NEO4J_HOME"), new String[0]);
        Path configDir = Paths.get(System.getenv("NEO4J_CONF"), new String[0]);
        String extraHelp = System.getenv("NEO4J_EXTRA_HELP");
        boolean debug = System.getenv("NEO4J_DEBUG") != null;
        new AdminTool(new ServiceCommandLocator(), System.out::println, extraHelp, debug).execute(homeDir, configDir, args).exit();
    }

    public AdminTool(CommandLocator locator, Output out, String extraHelp, boolean debug) {
        this.locator = new AppendingLocator(this.help(), locator);
        this.out = out;
        this.debug = debug;
        this.usage = new Usage("neo4j-admin", out, this.locator, extraHelp);
    }

    public Result execute(Path homeDir, Path configDir, String ... args) {
        try {
            AdminCommand.Provider provider;
            String name = args[0];
            String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
            try {
                provider = (AdminCommand.Provider)((Object)this.locator.apply(name));
            }
            catch (NoSuchElementException e) {
                return this.badUsage(name, commandArgs);
            }
            AdminCommand command = provider.create(homeDir, configDir);
            try {
                command.execute(commandArgs);
                return AdminTool.success();
            }
            catch (IncorrectUsage e) {
                return this.badUsage(provider, e);
            }
            catch (CommandFailed e) {
                return this.failure(e);
            }
        }
        catch (RuntimeException e) {
            return this.unexpected(e);
        }
    }

    private Supplier<AdminCommand.Provider> help() {
        return () -> new HelpCommand.Provider(this.usage);
    }

    private Result badUsage(AdminCommand.Provider command, IncorrectUsage e) {
        new Usage.CommandUsage(command, this.out, "neo4j-admin").print();
        return AdminTool.failure(e.getMessage());
    }

    private Result badUsage(String name, String[] commandArgs) {
        this.usage.print();
        String message = commandArgs.length == 0 ? String.format("unrecognized command: %s", name) : commandArgs[0];
        return AdminTool.failure(message);
    }

    private Result unexpected(RuntimeException e) {
        return this.failure(e, "unexpected error: " + e.getMessage());
    }

    private Result failure(Throwable e) {
        if (this.debug) {
            return this.failure(e, e.getMessage());
        }
        return AdminTool.failure(e.getMessage());
    }

    private Result failure(Throwable e, String message) {
        return () -> {
            e.printStackTrace();
            AdminTool.failure(message).exit();
        };
    }

    private static Result failure(String message) {
        return () -> {
            System.err.println(message);
            System.exit(1);
        };
    }

    private static Result success() {
        return () -> System.exit(0);
    }

    private class AppendingLocator
    implements CommandLocator {
        private final Supplier<AdminCommand.Provider> command;
        private final CommandLocator commands;

        public AppendingLocator(Supplier<AdminCommand.Provider> command, CommandLocator commands) {
            this.command = command;
            this.commands = commands;
        }

        @Override
        public AdminCommand.Provider apply(String name) {
            AdminCommand.Provider provider = this.command.get();
            return Objects.equals(name, provider.name()) ? provider : (AdminCommand.Provider)((Object)this.commands.apply(name));
        }

        @Override
        public Iterable<AdminCommand.Provider> get() {
            return Iterables.append((Object)((Object)this.command.get()), (Iterable)((Iterable)this.commands.get()));
        }
    }

    private static class ServiceCommandLocator
    implements CommandLocator {
        private ServiceCommandLocator() {
        }

        @Override
        public AdminCommand.Provider apply(String name) {
            return (AdminCommand.Provider)Service.load(AdminCommand.Provider.class, (String)name);
        }

        @Override
        public Iterable<AdminCommand.Provider> get() {
            return Service.load(AdminCommand.Provider.class);
        }
    }

    public static interface CommandLocator
    extends Function<String, AdminCommand.Provider>,
    Supplier<Iterable<AdminCommand.Provider>> {
    }

    private static interface Result {
        public void exit();
    }
}

