/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.BlockLogBuffer;
import org.neo4j.com.Protocol;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class ToNetworkStoreWriter
implements StoreWriter {
    public static final String STORE_COPIER_MONITOR_TAG = "storeCopier";
    private final ChannelBuffer targetBuffer;
    private final ByteCounterMonitor bufferMonitor;

    public ToNetworkStoreWriter(ChannelBuffer targetBuffer, Monitors monitors) {
        this.targetBuffer = targetBuffer;
        this.bufferMonitor = (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, this.getClass(), new String[]{STORE_COPIER_MONITOR_TAG});
    }

    @Override
    public long write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
        char[] chars = path.toCharArray();
        this.targetBuffer.writeShort(chars.length);
        Protocol.writeChars(this.targetBuffer, chars);
        this.targetBuffer.writeByte(hasData ? 1 : 0);
        BlockLogBuffer buffer = new BlockLogBuffer(this.targetBuffer, this.bufferMonitor);
        long totalWritten = 2 + chars.length * 2 + 1;
        if (hasData) {
            totalWritten += (long)buffer.write(data);
            buffer.close();
        }
        return totalWritten;
    }

    @Override
    public void close() {
        this.targetBuffer.writeShort(0);
    }
}

