/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.storageengine.api.ReadPastEndException;

public class NetworkReadableClosableChannel
implements ReadableClosablePositionAwareChannel {
    private final ChannelBuffer delegate;

    public NetworkReadableClosableChannel(ChannelBuffer input) {
        this.delegate = input;
    }

    public byte get() throws IOException {
        try {
            return this.delegate.readByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    public short getShort() throws IOException {
        try {
            return this.delegate.readShort();
        }
        catch (IndexOutOfBoundsException e) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    public int getInt() throws IOException {
        try {
            return this.delegate.readInt();
        }
        catch (IndexOutOfBoundsException e) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    public long getLong() throws IOException {
        try {
            return this.delegate.readLong();
        }
        catch (IndexOutOfBoundsException e) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    public float getFloat() throws IOException {
        try {
            return this.delegate.readFloat();
        }
        catch (IndexOutOfBoundsException e) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    public double getDouble() throws IOException {
        try {
            return this.delegate.readDouble();
        }
        catch (IndexOutOfBoundsException e) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    public void get(byte[] bytes, int length) throws IOException {
        try {
            this.delegate.readBytes(bytes, 0, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.unspecified();
        return positionMarker;
    }

    public void close() throws IOException {
    }
}

