/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jboss.netty.buffer.ChannelBuffer;

public class BlockLogReader
implements ReadableByteChannel {
    private final ChannelBuffer source;
    private final byte[] byteArray = new byte[256];
    private final ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArray);
    private boolean moreBlocks;

    public BlockLogReader(ChannelBuffer source) {
        this.source = source;
        this.readNextBlock();
    }

    private void readNextBlock() {
        short blockSize = this.source.readUnsignedByte();
        this.byteBuffer.clear();
        this.moreBlocks = blockSize == 0;
        int limit = this.moreBlocks ? 255 : (int)blockSize;
        this.byteBuffer.limit(limit);
        this.source.readBytes(this.byteBuffer);
        this.byteBuffer.flip();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.readToTheEnd();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytesReadThisTime;
        int bytesRead = 0;
        for (int bytesWanted = dst.limit(); bytesWanted > 0 && (bytesReadThisTime = this.readAsMuchAsPossible(dst, bytesWanted)) != 0; bytesWanted -= bytesReadThisTime) {
            bytesRead += bytesReadThisTime;
        }
        return bytesRead == 0 && !this.moreBlocks ? -1 : bytesRead;
    }

    private int readAsMuchAsPossible(ByteBuffer dst, int maxBytesWanted) {
        if (this.byteBuffer.remaining() == 0 && this.moreBlocks) {
            this.readNextBlock();
        }
        int bytesToRead = Math.min(maxBytesWanted, this.byteBuffer.remaining());
        dst.put(this.byteArray, this.byteBuffer.position(), bytesToRead);
        this.byteBuffer.position(this.byteBuffer.position() + bytesToRead);
        return bytesToRead;
    }

    private void readToTheEnd() {
        while (this.moreBlocks) {
            this.readNextBlock();
        }
    }
}

