/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public abstract class AbstractHeapTrackingConcurrentHash {
    static final Object RESIZE_SENTINEL = new Object();
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final AtomicReferenceFieldUpdater<AbstractHeapTrackingConcurrentHash, AtomicReferenceArray<Object>> TABLE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractHeapTrackingConcurrentHash.class, AtomicReferenceArray.class, "table");
    private static final AtomicIntegerFieldUpdater<AbstractHeapTrackingConcurrentHash> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractHeapTrackingConcurrentHash.class, "size");
    static final Object RESIZED = new Object();
    static final Object RESIZING = new Object();
    static final int PARTITIONED_SIZE_THRESHOLD = 4096;
    static final int SIZE_BUCKETS = 7;
    static final int PARTITIONED_SIZE = 112;
    static final long SHALLOW_SIZE_ATOMIC_REFERENCE_ARRAY = HeapEstimator.shallowSizeOfInstance(AtomicReferenceArray.class);
    static final long SIZE_INTEGER_REFERENCE_ARRAY = HeapEstimator.shallowSizeOfInstance(AtomicIntegerArray.class) + HeapEstimator.sizeOfIntArray((int)112);
    volatile AtomicReferenceArray<Object> table;
    private AtomicIntegerArray partitionedSize;
    private volatile int size;
    final MemoryTracker memoryTracker;
    private volatile int trackedCapacity;

    AbstractHeapTrackingConcurrentHash(MemoryTracker memoryTracker, int initialCapacity) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        int threshold = initialCapacity;
        threshold += threshold >> 1;
        for (capacity = 1; capacity < threshold; capacity <<= 1) {
        }
        if (capacity >= 4096) {
            this.partitionedSize = this.allocateAtomicIntegerArray();
        }
        this.memoryTracker = memoryTracker;
        this.table = this.allocateAtomicReferenceArray(capacity + 1);
    }

    static int indexFor(int h, int length) {
        return h & length - 2;
    }

    public abstract long sizeOfWrapperObject();

    private AtomicReferenceArray<Object> allocateAtomicReferenceArray(int newSize) {
        this.memoryTracker.allocateHeap(AbstractHeapTrackingConcurrentHash.shallowSizeOfAtomicReferenceArray(newSize));
        this.memoryTracker.releaseHeap(AbstractHeapTrackingConcurrentHash.shallowSizeOfAtomicReferenceArray(this.trackedCapacity));
        this.trackedCapacity = newSize;
        return new AtomicReferenceArray<Object>(newSize);
    }

    private AtomicIntegerArray allocateAtomicIntegerArray() {
        this.memoryTracker.allocateHeap(SIZE_INTEGER_REFERENCE_ARRAY);
        return new AtomicIntegerArray(112);
    }

    private static long shallowSizeOfAtomicReferenceArray(int size) {
        return size == 0 ? 0L : HeapEstimator.shallowSizeOfObjectArray((int)size) + SHALLOW_SIZE_ATOMIC_REFERENCE_ARRAY;
    }

    void incrementSizeAndPossiblyResize(AtomicReferenceArray<Object> currentArray, int length, Object prev) {
        int threshold;
        int localSize;
        this.addToSize(1);
        if (prev != null && (localSize = this.size()) + 1 > (threshold = (length >> 1) + (length >> 2))) {
            this.resize(currentArray);
        }
    }

    int hash(Object key) {
        return this.hash(key.hashCode());
    }

    final int hash(long key) {
        return this.hash(Long.hashCode(key));
    }

    final int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h;
    }

    final AtomicReferenceArray<Object> helpWithResizeWhileCurrentIndex(AtomicReferenceArray<Object> currentArray, int index) {
        AtomicReferenceArray<Object> newArray = this.helpWithResize(currentArray);
        int helpCount = 0;
        while (currentArray.get(index) != RESIZED) {
            newArray = this.helpWithResize(currentArray);
            if ((++helpCount & 7) != 0) continue;
            Thread.yield();
        }
        return newArray;
    }

    final AtomicReferenceArray<Object> helpWithResize(AtomicReferenceArray<Object> currentArray) {
        ResizeContainer resizeContainer = (ResizeContainer)currentArray.get(currentArray.length() - 1);
        AtomicReferenceArray<Object> newTable = resizeContainer.nextArray;
        if (resizeContainer.getQueuePosition() > ResizeContainer.QUEUE_INCREMENT) {
            resizeContainer.incrementResizer();
            this.reverseTransfer(currentArray, resizeContainer);
            resizeContainer.decrementResizerAndNotify();
        }
        return newTable;
    }

    private void resize(AtomicReferenceArray<Object> oldTable) {
        this.resize(oldTable, (oldTable.length() - 1 << 1) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize(AtomicReferenceArray<Object> oldTable, int newSize) {
        int oldCapacity = oldTable.length();
        int end = oldCapacity - 1;
        Object last = oldTable.get(end);
        int localSize = this.size();
        if (localSize < end && last == RESIZE_SENTINEL) {
            return;
        }
        if (oldCapacity >= 0x40000000) {
            throw new RuntimeException("index is too large!");
        }
        ResizeContainer resizeContainer = null;
        boolean ownResize = false;
        if (last == null || last == RESIZE_SENTINEL) {
            AtomicReferenceArray<Object> atomicReferenceArray = oldTable;
            synchronized (atomicReferenceArray) {
                if (oldTable.get(end) == null) {
                    oldTable.set(end, RESIZE_SENTINEL);
                    if (this.partitionedSize == null && newSize >= 4096) {
                        this.partitionedSize = this.allocateAtomicIntegerArray();
                    }
                    resizeContainer = new ResizeContainer(this.allocateAtomicReferenceArray(newSize), oldTable.length() - 1);
                    oldTable.set(end, resizeContainer);
                    ownResize = true;
                }
            }
        }
        if (ownResize) {
            this.transfer(oldTable, resizeContainer);
            AtomicReferenceArray<Object> src = this.table;
            while (!TABLE_UPDATER.compareAndSet(this, oldTable, resizeContainer.nextArray)) {
                if (src == oldTable) continue;
                this.helpWithResize(src);
            }
        } else {
            this.helpWithResize(oldTable);
        }
    }

    abstract void transfer(AtomicReferenceArray<Object> var1, ResizeContainer var2);

    abstract void reverseTransfer(AtomicReferenceArray<Object> var1, ResizeContainer var2);

    public int size() {
        int localSize = this.size;
        if (this.partitionedSize != null) {
            for (int i = 0; i < 7; ++i) {
                localSize += this.partitionedSize.get(i << 4);
            }
        }
        return localSize;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    final void addToSize(int value) {
        if (this.partitionedSize != null && this.incrementPartitionedSize(value)) {
            return;
        }
        this.incrementLocalSize(value);
    }

    private boolean incrementPartitionedSize(int value) {
        int h = (int)Thread.currentThread().getId();
        h ^= h >>> 18 ^ h >>> 12;
        if ((h = (h ^ h >>> 10) & 7) != 0) {
            int localSize;
            h = h - 1 << 4;
            while (!this.partitionedSize.compareAndSet(h, localSize = this.partitionedSize.get(h), localSize + value)) {
            }
            return true;
        }
        return false;
    }

    private void incrementLocalSize(int value) {
        int localSize;
        while (!SIZE_UPDATER.compareAndSet(this, localSize = this.size, localSize + value)) {
        }
    }

    public void releaseHeap() {
        this.memoryTracker.releaseHeap(AbstractHeapTrackingConcurrentHash.shallowSizeOfAtomicReferenceArray(this.trackedCapacity));
        if (this.partitionedSize != null) {
            this.memoryTracker.releaseHeap(SIZE_INTEGER_REFERENCE_ARRAY);
        }
    }

    static final class ResizeContainer {
        static final int QUEUE_INCREMENT = Math.min(1024, Integer.highestOneBit(Runtime.getRuntime().availableProcessors()) << 4);
        final AtomicInteger resizers = new AtomicInteger(1);
        final AtomicReferenceArray<Object> nextArray;
        final AtomicInteger queuePosition;

        ResizeContainer(AtomicReferenceArray<Object> nextArray, int oldSize) {
            this.nextArray = nextArray;
            this.queuePosition = new AtomicInteger(oldSize);
        }

        public void incrementResizer() {
            this.resizers.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrementResizerAndNotify() {
            int remaining = this.resizers.decrementAndGet();
            if (remaining == 0) {
                ResizeContainer resizeContainer = this;
                synchronized (resizeContainer) {
                    this.notifyAll();
                }
            }
        }

        public int getQueuePosition() {
            return this.queuePosition.get();
        }

        public int subtractAndGetQueuePosition() {
            return this.queuePosition.addAndGet(-QUEUE_INCREMENT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForAllResizers() {
            if (this.resizers.get() > 0) {
                int i;
                for (i = 0; i < 16 && this.resizers.get() != 0; ++i) {
                }
                for (i = 0; i < 16 && this.resizers.get() != 0; ++i) {
                    Thread.yield();
                }
            }
            if (this.resizers.get() > 0) {
                ResizeContainer resizeContainer = this;
                synchronized (resizeContainer) {
                    while (this.resizers.get() > 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        public boolean isNotDone() {
            return this.resizers.get() > 0;
        }

        public void zeroOutQueuePosition() {
            this.queuePosition.set(0);
        }
    }

    abstract class HashIterator<WRAPPER extends Wrapper<?>> {
        private List<IteratorState> todo;
        private IteratorState currentState;
        WRAPPER next;
        WRAPPER current;
        private int index;

        protected HashIterator() {
            this.currentState = new IteratorState(AbstractHeapTrackingConcurrentHash.this.table);
            this.findNext();
        }

        final void findNext() {
            while (this.index < this.currentState.end) {
                Object o = this.currentState.currentTable.get(this.index);
                if (o == RESIZED || o == RESIZING) {
                    int endResized;
                    AtomicReferenceArray<Object> nextArray = AbstractHeapTrackingConcurrentHash.this.helpWithResizeWhileCurrentIndex(this.currentState.currentTable, this.index);
                    for (endResized = this.index + 1; endResized < this.currentState.end && this.currentState.currentTable.get(endResized) == RESIZED; ++endResized) {
                    }
                    if (this.todo == null) {
                        this.todo = new FastList(4);
                    }
                    if (endResized < this.currentState.end) {
                        this.todo.add(new IteratorState(this.currentState.currentTable, endResized, this.currentState.end));
                    }
                    int powerTwoLength = this.currentState.currentTable.length() - 1;
                    this.todo.add(new IteratorState(nextArray, this.index + powerTwoLength, endResized + powerTwoLength));
                    this.currentState.currentTable = nextArray;
                    this.currentState.end = endResized;
                    this.currentState.start = this.index;
                    continue;
                }
                if (o != null) {
                    this.next = (Wrapper)o;
                    ++this.index;
                    break;
                }
                ++this.index;
            }
            if (this.next == null && this.index == this.currentState.end && this.todo != null && !this.todo.isEmpty()) {
                this.currentState = this.todo.remove(this.todo.size() - 1);
                this.index = this.currentState.start;
                this.findNext();
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }
    }

    static interface Wrapper<W> {
        public W getNext();
    }

    static final class IteratorState {
        AtomicReferenceArray<Object> currentTable;
        int start;
        int end;

        IteratorState(AtomicReferenceArray<Object> currentTable) {
            this.currentTable = currentTable;
            this.end = this.currentTable.length() - 1;
        }

        IteratorState(AtomicReferenceArray<Object> currentTable, int start, int end) {
            this.currentTable = currentTable;
            this.start = start;
            this.end = end;
        }
    }
}

