/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.diffset;

import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.diffset.MutableLongDiffSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class MutableLongDiffSetsImpl
implements MutableLongDiffSets {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(MutableLongDiffSetsImpl.class);
    private static final MutableLongSet NOT_INITIALIZED = LongSets.mutable.empty().asUnmodifiable();
    private final CollectionsFactory collectionsFactory;
    private final MemoryTracker memoryTracker;
    private MutableLongSet added;
    private MutableLongSet removed;

    static MutableLongDiffSetsImpl createMutableLongDiffSetsImpl(CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new MutableLongDiffSetsImpl(collectionsFactory, memoryTracker);
    }

    @VisibleForTesting
    public MutableLongDiffSetsImpl(MutableLongSet added, MutableLongSet removed, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        this.added = added;
        this.removed = removed;
        this.collectionsFactory = collectionsFactory;
        this.memoryTracker = memoryTracker;
    }

    @VisibleForTesting
    public MutableLongDiffSetsImpl(CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        this(NOT_INITIALIZED, NOT_INITIALIZED, collectionsFactory, memoryTracker);
    }

    @Override
    public boolean isAdded(long element) {
        return this.added.contains(element);
    }

    @Override
    public boolean isRemoved(long element) {
        return this.removed.contains(element);
    }

    @Override
    public void add(long element) {
        this.checkAddedElements();
        this.addElement(element);
    }

    @Override
    public boolean remove(long element) {
        this.checkRemovedElements();
        return this.removeElement(element);
    }

    @Override
    public int delta() {
        return this.added.size() - this.removed.size();
    }

    @Override
    public LongSet getAdded() {
        return this.added;
    }

    @Override
    public LongSet getRemoved() {
        return this.removed;
    }

    @Override
    public LongSet getRemovedFromAdded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.added.isEmpty() && this.removed.isEmpty();
    }

    private void addElement(long element) {
        if (this.removed.isEmpty() || !this.removed.remove(element)) {
            this.added.add(element);
        }
    }

    private boolean removeElement(long element) {
        if (!this.added.isEmpty() && this.added.remove(element)) {
            return true;
        }
        return this.removed.add(element);
    }

    private void checkAddedElements() {
        if (this.added == NOT_INITIALIZED) {
            this.added = this.collectionsFactory.newLongSet(this.memoryTracker);
        }
    }

    private void checkRemovedElements() {
        if (this.removed == NOT_INITIALIZED) {
            this.removed = this.collectionsFactory.newLongSet(this.memoryTracker);
        }
    }
}

