/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.trackable.AbstractHeapTrackingConcurrentHash;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public final class HeapTrackingConcurrentLongHashSet
extends AbstractHeapTrackingConcurrentHash
implements AutoCloseable {
    private static final long SHALLOW_SIZE_THIS = HeapEstimator.shallowSizeOfInstance(HeapTrackingConcurrentLongHashSet.class);
    private static final long SHALLOW_SIZE_WRAPPER = HeapEstimator.shallowSizeOfInstance(Node.class);

    @Override
    public long sizeOfWrapperObject() {
        return SHALLOW_SIZE_WRAPPER;
    }

    public static HeapTrackingConcurrentLongHashSet newSet(MemoryTracker memoryTracker) {
        return HeapTrackingConcurrentLongHashSet.newSet(memoryTracker, 16);
    }

    public static HeapTrackingConcurrentLongHashSet newSet(MemoryTracker memoryTracker, int size) {
        memoryTracker.allocateHeap(SHALLOW_SIZE_THIS);
        return new HeapTrackingConcurrentLongHashSet(memoryTracker, size);
    }

    private HeapTrackingConcurrentLongHashSet(MemoryTracker memoryTracker, int initialCapacity) {
        super(memoryTracker, initialCapacity);
    }

    public boolean add(long value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(Long.hashCode(value));
        int index = HeapTrackingConcurrentLongHashSet.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null) {
            Node newNode = new Node(value, null);
            this.addToSize(1);
            if (currentArray.compareAndSet(index, null, newNode)) {
                return true;
            }
            this.addToSize(-1);
        }
        return this.slowAdd(value, hash, currentArray);
    }

    private boolean slowAdd(long value, int hash, AtomicReferenceArray<Object> currentArray) {
        int length;
        Object o;
        while (true) {
            int index;
            if ((o = currentArray.get(index = HeapTrackingConcurrentLongHashSet.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Node e = (Node)o; e != null; e = e.getNext()) {
                long candidate = e.value;
                if (candidate != value) continue;
                return false;
            }
            Node newNode = new Node(value, (Node)o);
            if (currentArray.compareAndSet(index, o, newNode)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return true;
    }

    @Override
    void transfer(AtomicReferenceArray<Object> src, AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer) {
        AtomicReferenceArray<Object> dest = resizeContainer.nextArray;
        int j = 0;
        while (j < src.length() - 1) {
            Object o = src.get(j);
            if (o == null) {
                if (!src.compareAndSet(j, null, RESIZED)) continue;
                ++j;
                continue;
            }
            if (o == RESIZED || o == RESIZING) {
                j = (j & -AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT) + AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT;
                if (resizeContainer.resizers.get() != 1) continue;
                break;
            }
            if (!src.compareAndSet(j, o, RESIZING)) continue;
            for (Node e = (Node)o; e != null; e = e.getNext()) {
                this.unconditionalCopy(dest, e);
            }
            src.set(j, RESIZED);
            ++j;
        }
        resizeContainer.decrementResizerAndNotify();
        resizeContainer.waitForAllResizers();
    }

    @Override
    void reverseTransfer(AtomicReferenceArray<Object> src, AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer) {
        AtomicReferenceArray<Object> dest = resizeContainer.nextArray;
        while (resizeContainer.getQueuePosition() > 0) {
            int start = resizeContainer.subtractAndGetQueuePosition();
            int end = start + AbstractHeapTrackingConcurrentHash.ResizeContainer.QUEUE_INCREMENT;
            if (end <= 0) continue;
            if (start < 0) {
                start = 0;
            }
            int j = end - 1;
            while (j >= start) {
                Object o = src.get(j);
                if (o == null) {
                    if (!src.compareAndSet(j, null, RESIZED)) continue;
                    --j;
                    continue;
                }
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer.zeroOutQueuePosition();
                    return;
                }
                if (!src.compareAndSet(j, o, RESIZING)) continue;
                for (Node e = (Node)o; e != null; e = e.getNext()) {
                    this.unconditionalCopy(dest, e);
                }
                src.set(j, RESIZED);
                --j;
            }
        }
    }

    private void unconditionalCopy(AtomicReferenceArray<Object> dest, Node toCopyNode) {
        int hash = this.hash(Long.hashCode(toCopyNode.value));
        AtomicReferenceArray<Object> currentArray = dest;
        while (true) {
            int length;
            int index;
            Object o;
            if ((o = currentArray.get(index = HeapTrackingConcurrentLongHashSet.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = ((AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get((int)(length - 1))).nextArray;
                continue;
            }
            Node newNode = o == null ? (toCopyNode.getNext() == null ? toCopyNode : new Node(toCopyNode.value)) : new Node(toCopyNode.value, (Node)o);
            if (currentArray.compareAndSet(index, o, newNode)) break;
        }
    }

    public boolean contains(long value) {
        int length;
        int index;
        Object o;
        int hash = this.hash(value);
        AtomicReferenceArray<Object> currentArray = this.table;
        while ((o = currentArray.get(index = HeapTrackingConcurrentLongHashSet.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
        }
        for (Node e = (Node)o; e != null; e = e.getNext()) {
            long candidate = e.value;
            if (candidate != value) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        AbstractHeapTrackingConcurrentHash.ResizeContainer resizeContainer;
        AtomicReferenceArray<Object> currentArray = this.table;
        do {
            resizeContainer = null;
            for (int i = 0; i < currentArray.length() - 1; ++i) {
                Object o = currentArray.get(i);
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer = (AbstractHeapTrackingConcurrentHash.ResizeContainer)currentArray.get(currentArray.length() - 1);
                    continue;
                }
                if (o == null) continue;
                if (!currentArray.compareAndSet(i, o, null)) continue;
                int removedEntries = 0;
                for (Node e = (Node)o; e != null; e = e.getNext()) {
                    ++removedEntries;
                }
                this.addToSize(-removedEntries);
            }
            if (resizeContainer == null) continue;
            if (resizeContainer.isNotDone()) {
                this.helpWithResize(currentArray);
                resizeContainer.waitForAllResizers();
            }
            currentArray = resizeContainer.nextArray;
        } while (resizeContainer != null);
    }

    public boolean remove(long value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(Long.hashCode(value));
        int index = HeapTrackingConcurrentLongHashSet.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowRemove(value, hash, currentArray);
        }
        for (Node e = (Node)o; e != null; e = e.getNext()) {
            long candidate = e.value;
            if (candidate != value) continue;
            Node replacement = this.createReplacementChainForRemoval((Node)o, e);
            if (currentArray.compareAndSet(index, o, replacement)) {
                this.addToSize(-1);
                return true;
            }
            return this.slowRemove(value, hash, currentArray);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean slowRemove(long value, int hash, AtomicReferenceArray<Object> currentArray) {
        block0: while (true) {
            if ((o = currentArray.get(index = HeapTrackingConcurrentLongHashSet.indexFor(hash, length = currentArray.length()))) == HeapTrackingConcurrentLongHashSet.RESIZED || o == HeapTrackingConcurrentLongHashSet.RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (e = (Node)o; e != null; e = e.getNext()) {
                candidate = e.value;
                if (candidate != value) continue;
                replacement = this.createReplacementChainForRemoval((Node)o, e);
                if (currentArray.compareAndSet(index, o, replacement)) ** break;
                continue block0;
                this.addToSize(-1);
                return true;
            }
            break;
        }
        return false;
    }

    private Node createReplacementChainForRemoval(Node original, Node toRemove) {
        if (original == toRemove) {
            return original.getNext();
        }
        Node replacement = null;
        for (Node e = original; e != null; e = e.getNext()) {
            if (e == toRemove) continue;
            replacement = new Node(e.value, replacement);
        }
        return replacement;
    }

    public int hashCode() {
        int h = 0;
        AtomicReferenceArray currentArray = this.table;
        for (int i = 0; i < currentArray.length() - 1; ++i) {
            Object o = currentArray.get(i);
            if (o == RESIZED || o == RESIZING) {
                throw new ConcurrentModificationException("can't compute hashcode while resizing!");
            }
            for (Node e = (Node)o; e != null; e = e.getNext()) {
                long value = e.value;
                h += Long.hashCode(value);
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeapTrackingConcurrentLongHashSet)) {
            return false;
        }
        HeapTrackingConcurrentLongHashSet s = (HeapTrackingConcurrentLongHashSet)o;
        if (s.size() != this.size()) {
            return false;
        }
        LongIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            long e = iterator.next();
            if (s.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(SHALLOW_SIZE_THIS);
        this.releaseHeap();
    }

    public LongIterator iterator() {
        return new LongHashSetIterator();
    }

    private static final class Node
    implements AbstractHeapTrackingConcurrentHash.Wrapper<Node> {
        private final long value;
        private final Node next;

        private Node(long value) {
            this.value = value;
            this.next = null;
        }

        private Node(long value, Node next) {
            this.value = value;
            this.next = next;
        }

        @Override
        public Node getNext() {
            return this.next;
        }
    }

    private class LongHashSetIterator
    extends AbstractHeapTrackingConcurrentHash.HashIterator<Node>
    implements LongIterator {
        private LongHashSetIterator() {
        }

        public long next() {
            Node e = (Node)this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.getNext();
            if (this.next == null) {
                this.findNext();
            }
            return e.value;
        }
    }
}

